% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RadEro_run.R
\name{RadEro_run}
\alias{RadEro_run}
\title{Starts conversion model for soil redistribution}
\usage{
RadEro_run(data, config, AxisMaxValue = NULL, output_dir = NULL)
}
\arguments{
\item{data}{A data frame containing the Cs137 inventory data from soil profiles. It must be located in the working directory.}

\item{config}{A list or configuration file that defines the parameters for the model run. It must be located in the working directory.}

\item{AxisMaxValue}{Optional. A numeric value specifying the maximum value for the axes in the plot. Defaults to NULL.}

\item{output_dir}{The directory where the output files will be saved. Defaults to a temporary directory.}
}
\value{
A "results" folder containing for each analyzed profile: a) ID_plot.png: Experimental (blue) and simulated (red) inventory depth profile plots; b) ID_tempfile: Experimental inventory (Bq/kg) per cell unit in the defined profile depth; c) results.txt: Summary file with columns for ID, migration rate (e), erosion rate (m), diffusion coefficients (k and kv), total experimental inventory, and total simulated inventory; d) Additionally, a "temp" folder for advanced users is created for each profile, containing configuration and inventory files related to individual analyses.
}
\description{
Initiates the model based on the Cs137 inventory data from soil profiles according to the specified configuration in the working directory.
}
