% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_radviz.R
\name{theme_radviz}
\alias{theme_radviz}
\title{Complete ggplot2 theme for Radviz projections}
\usage{
theme_radviz(
  base_size = 11,
  base_family = "",
  base_line_size = base_size/22,
  base_rect_size = base_size/22
)
}
\arguments{
\item{base_size}{base font size, given in pts.}

\item{base_family}{base font family}

\item{base_line_size}{base size for line elements}

\item{base_rect_size}{base size for rect elements}
}
\value{
a complete ggplot2 theme
}
\description{
A complete Radviz theme based on `ggplot2::theme_light`
}
\details{
on top of `ggplot2::theme_light` this theme removes axis title, text and ticks, 
as well as the reference grid. See \code{\link[ggplot2]{theme}} for details.
}
\examples{
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
S <- make.S(das)
rv <- do.radviz(iris,S)
plot(rv,main='Iris projection')
plot(rv,main='Iris projection')+
  theme_radviz(base_size=16)

}
\author{
Yann Abraham
}
