% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifetable_convert.R
\name{lifetable_convert}
\alias{lifetable_convert}
\alias{lx_to_px}
\alias{lx_to_hx}
\alias{px_to_lx}
\alias{px_to_hx}
\alias{hx_to_lx}
\alias{hx_to_px}
\title{Convert between age-specific survivorship, survival, or mortality hazard}
\usage{
lx_to_px(lx)

lx_to_hx(lx)

px_to_lx(px)

px_to_hx(px)

hx_to_lx(hx)

hx_to_px(hx)
}
\arguments{
\item{lx}{Vector of age-specific survivorship.}

\item{px}{Vector of age-specific survival probabilities.}

\item{hx}{Vector of age-specific mortality hazards.}
}
\value{
A vector.
}
\description{
Convert between vectors of age-specific survivorship (\code{lx}), survival
probability (\code{px}), or mortality hazard (\code{hx}). Input vectors must
be arranged in order of increasing age, starting with age 0.
}
\details{
\code{lx} gives the proportional survivorship to the start of age
  class \code{x} (where survivorship at first age class is defined as 1),
  \code{px} gives the probability of survival between age \code{x} and
  \code{x+1}, and \code{hx} gives the time-averaged mortality hazard (also
  called force of mortality) between age \code{x} and \code{x+1}.
}
\note{
Note that the units of time for the returned vectors (i.e., \code{x})
  are the same as the (\code{ProjectionInterval}) of the MPM.
}
\examples{
lx <- c(1, 0.8, 0.7, 0.5, 0.3, 0.1)

# convert from lx
px <- lx_to_px(lx)
hx <- lx_to_hx(lx)

# convert from px
lx <- px_to_lx(px)
hx <- px_to_hx(px)

# convert from hx
lx <- hx_to_lx(hx)
px <- hx_to_px(hx)

}
\references{
Caswell, H. 2001. Matrix Population Models: Construction, Analysis, and
Interpretation. Sinauer Associates; 2nd edition. ISBN: 978-0878930968

Caswell, H. 2006. Applications of Markov chains in demography. pp. 319-334 in
A.N. Langville and W.J. Stewart (editors) MAM2006: Markov Anniversary
Meeting. Boson Books, Raleigh, North Caroline, USA

Ergon, T., Borgan, Ø., Nater, C. R., & Vindenes, Y. 2018. The utility of
mortality hazard rates in population analyses. Methods in Ecology and
Evolution, 9, 2046-2056. <doi:10.1111/2041-210X.13059>

Horvitz, C. & Tuljapurkar, S. 2008. Stage dynamics, period survival, and
mortality plateaus. The American Naturalist 172: 203-2015.
<doi:10.1086/589453>

Jones, O. R., Scheuerlein, A., Salguero-Gomez, R., Camarda, C. G., Schaible,
R., Casper, B. B., Dahlgren, J. P., Ehrlén, J., García, M. B., Menges, E.,
Quintana-Ascencio, P. F., Caswell, H., Baudisch, A. & Vaupel, J. 2014.
Diversity of ageing across the tree of life. Nature 505, 169-173.
<doi:10.1038/nature12789>

Jones O. R. 2021. Life tables: Construction and interpretation In:
Demographic Methods Across the Tree of Life. Edited by Salguero-Gomez R &
Gamelon M. Oxford University Press. Oxford, UK. ISBN: 9780198838609

Preston, S., Heuveline, P., & Guillot, M. 2000. Demography: Measuring and
Modeling Population Processes. Wiley. ISBN: 9781557864512
}
\seealso{
Other life tables: 
\code{\link{age_from_stage}},
\code{\link{mpm_to_table}()},
\code{\link{qsd_converge}()}
}
\author{
Patrick Barks <patrick.barks@gmail.com>
}
\concept{life tables}
