% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form_matrix.R
\name{form_matrix}
\alias{form_matrix}
\title{Forms the Projection Matrix}
\usage{
form_matrix(rows, cols, JLT, eps = 0.1, projection = "gaussian")
}
\arguments{
\item{rows}{- number of rows}

\item{cols}{- number of columns}

\item{JLT}{- Boolean to set JL transform (TRUE or FALSE)}

\item{eps}{- error tolerance level with default value 0.1}

\item{projection}{- projection function with default value "gaussian"}
}
\value{
Projection Matrix
}
\description{
The projection function is used to generate the random projection matrix. It will form either dense or spare
 projection matrix. The Package supports 4 projection functions namely gaussian, probability, achlioptas and li.
 The number of rows and columns of the input sample is passed with the boolean value JLT. If JLT is set to TRUE,
 the dimension of the input data is reduced to the value returned by dimension() method.
 For Dense Matrix -  "gaussian" method
 For Sparse Matrix - "probability, achlioptas and li" method.
}
\details{
The 4 projection functions are

1."gaussian" - The default projection function is "gaussian". In probability theory, Gaussian distribution is also
 called as normal distribution. It is a continuous probability distribution used to represent real-valued random
 variables. The elements in the random matrix are drawn from N(0,1/k), N is a Natural number and
 k value calculated based on JL - Lemma using dimension() function.

2. "probability" - In this method, the matrix was generated using the equal probability
distribution with the elements [-1, 1].

3. "achlioptas" - Achlioptas matrix is easy to generate and also the 2/3rd of the matrix was filled
with zero which makes it as more sparse and cut-off the 2/3rd computation.

4. "li" - This method generalizes the achlioptas method and generate very sparse random matrix
 to improve the computational speed up of random projection.

When comparing to gaussian function,  the other projection functions creates sparse matrix by filling with
zero's or one's to reduce the computation even more.
}
\examples{
# Load Library
library(RandPro)

# Default Gaussian projection matrix without JL transform
mat <- form_matrix(600,1000,FALSE)

# Default Gaussian projection matrix with JL transform of 50\% Error tolerance
mat <- form_matrix(300,100000,TRUE,0.5)

# Projection matrix with probability distribution of 50\% Error tolerance
mat <- form_matrix(250,1000000,TRUE,0.5,"probability")

# Projection matrix with li distribution of 50\% Error tolerance
mat <- form_matrix(250,1000000,TRUE,0.5,"li")

# Projection matrix with achlioptas distribution of 50\% Error tolerance
mat <- form_matrix(250,1000000,TRUE,0.5,"achlioptas")


}
\references{
[1] N.I.R. Ailon and B.Chazelle, "The Fast Johnson Lindenstrauss Transform and Approximate Nearest Neighbors(2009)"

[2] Ping Li, Trevor J. Hastie, and Kenneth W. Church,  "Very sparse random projections(2006)".

[3] D. Achlioptas, "Database-friendly random projections(2002)"
}
\author{
Aghila G

Siddharth R
}
\keyword{Achlioptas}
\keyword{Distribution}
\keyword{Gaussian}
\keyword{Li}
\keyword{Probability}
\keyword{Projection_matrix}
\keyword{sparse_matrix}
