% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc_functions.R
\name{consensusRanking}
\alias{consensusRanking}
\title{Rank aggregation of partial rankings}
\usage{
consensusRanking(x)
}
\arguments{
\item{x}{a \code{data.frame} containing columns titled \code{Reviewer}, \code{Item},
\code{Ranking}. On data structure, \code{Reviewer} and \code{Item} must be
character, and \code{Ranking} must be numeric. Each row of \code{x}
identifes the rank position that a single \code{Reviewer} awarded a single
\code{Item}}
}
\value{
A \code{data.frame} is returned,
with two columns: \code{Item} and \code{Rank}, where \code{Item}
is a \code{Factor} containing all unique \code{Item}'s from the input
\code{data.frame} \code{x}, and where \code{Rank} is the estimated
(numeric) rank position based on the branch and bound rank
aggregation procedure.
}
\description{
This function is the core function for the \code{\link{RankAggregator}} package.
This function uses a branch and bound algorithm, described by Cook et al. (2007),
to return a best consensus (or median) ranking for a set of (partial) rankings.
}
\examples{
consensusRanking(cook_example)
}
\seealso{
This function calls internal functions
\code{\link{evaluationMatrix}},
\code{\link{extendRanking}}, \code{\link{lowerBound}}, and
\code{\link{upperBound}}
}
