% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lag_df.R
\name{lag_df2}
\alias{lag_df2}
\title{lag_df2}
\usage{
lag_df2(df, laglist)
}
\arguments{
\item{df}{A data.frame or \code{tibble}.}

\item{laglist}{A list of column names where each index corresponds to a column
name and the associated value is the lag sequence.}
}
\value{
data.frame
}
\description{
The \code{lag_df2} function creates additional columns based on a list of column names
and lag sequences. This feature is beneficial for scenarios where you need
varying lag selections for certain columns, allowing flexibility in specifying
different lags for different columns or opting for no lag at all.
}
\examples{
df <- data.frame(a = 1:15, b = 2:16)
df2 <- lag_df2(df, laglist = list(a = 1:5, b = 1:3))
}
