# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @name damerau_levenshtein_distance
#' @title Damerau-Levenshtein Distance
#' @description Calculate the Damerau-Levenshtein distance between two strings.
#'
#' Computes the Damerau-Levenshtein distance, which is an edit distance allowing transpositions in addition
#' to substitutions, insertions, and deletions.
#'
#' @param s1 A string. The first input string.
#' @param s2 A string. The second input string.
#' @param score_cutoff An optional maximum threshold for the distance. Defaults to the largest
#' integer value in R (`.Machine$integer.max`).
#' @return The Damerau-Levenshtein distance as an integer.
#' @examples
#' damerau_levenshtein_distance("abcdef", "abcfde")
#' damerau_levenshtein_distance("abcdef", "abcfde", score_cutoff = 3)
#' @export
damerau_levenshtein_distance <- function(s1, s2, score_cutoff = NULL) {
    .Call(`_RapidFuzz_damerau_levenshtein_distance`, s1, s2, score_cutoff)
}

#' @name damerau_levenshtein_similarity
#' @title Damerau-Levenshtein Similarity
#' @description Calculate the Damerau-Levenshtein similarity between two strings.
#'
#' Computes the similarity based on the Damerau-Levenshtein metric, which considers transpositions in addition
#' to substitutions, insertions, and deletions.
#'
#' @param s1 A string. The first input string.
#' @param s2 A string. The second input string.
#' @param score_cutoff An optional minimum threshold for the similarity score. Defaults to 0.
#' @return The Damerau-Levenshtein similarity as an integer.
#' @examples
#' damerau_levenshtein_similarity("abcdef", "abcfde")
#' damerau_levenshtein_similarity("abcdef", "abcfde", score_cutoff = 3)
#' @export
damerau_levenshtein_similarity <- function(s1, s2, score_cutoff = 0L) {
    .Call(`_RapidFuzz_damerau_levenshtein_similarity`, s1, s2, score_cutoff)
}

#' @name damerau_levenshtein_normalized_distance
#' @title Normalized Damerau-Levenshtein Distance
#' @description Calculate the normalized Damerau-Levenshtein distance between two strings.
#'
#' Computes the normalized Damerau-Levenshtein distance, where the result is between
#' 0.0 (identical) and 1.0 (completely different).
#'
#' @param s1 A string. The first input string.
#' @param s2 A string. The second input string.
#' @param score_cutoff An optional maximum threshold for the normalized distance. Defaults to 1.0.
#' @return The normalized Damerau-Levenshtein distance as a double.
#' @examples
#' damerau_levenshtein_normalized_distance("abcdef", "abcfde")
#' damerau_levenshtein_normalized_distance("abcdef", "abcfde", score_cutoff = 0.5)
#' @export
damerau_levenshtein_normalized_distance <- function(s1, s2, score_cutoff = 1.0) {
    .Call(`_RapidFuzz_damerau_levenshtein_normalized_distance`, s1, s2, score_cutoff)
}

#' @name damerau_levenshtein_normalized_similarity
#' @title Normalized Damerau-Levenshtein Similarity
#' @description Calculate the normalized Damerau-Levenshtein similarity between two strings.
#'
#' Computes the normalized similarity based on the Damerau-Levenshtein metric, where the result is between
#' 0.0 (completely different) and 1.0 (identical).
#'
#' @param s1 A string. The first input string.
#' @param s2 A string. The second input string.
#' @param score_cutoff An optional minimum threshold for the normalized similarity. Defaults to 0.0.
#' @return The normalized Damerau-Levenshtein similarity as a double.
#' @examples
#' damerau_levenshtein_normalized_similarity("abcdef", "abcfde")
#' damerau_levenshtein_normalized_similarity("abcdef", "abcfde", score_cutoff = 0.7)
#' @export
damerau_levenshtein_normalized_similarity <- function(s1, s2, score_cutoff = 0.0) {
    .Call(`_RapidFuzz_damerau_levenshtein_normalized_similarity`, s1, s2, score_cutoff)
}

#' @title Get Edit Operations
#' @description Generates edit operations between two strings.
#' @param s1 The source string.
#' @param s2 The target string.
#' @return A DataFrame with edit operations.
#' @export
get_editops <- function(s1, s2) {
    .Call(`_RapidFuzz_get_editops`, s1, s2)
}

#' @title Apply Edit Operations to String
#' @description Applies edit operations to transform a string.
#' @param editops A data frame of edit operations (type, src_pos, dest_pos).
#' @param s1 The source string.
#' @param s2 The target string.
#' @return The transformed string.
#' @export
editops_apply_str <- function(editops, s1, s2) {
    .Call(`_RapidFuzz_editops_apply_str`, editops, s1, s2)
}

#' @title Apply Opcodes to String
#' @description Applies opcodes to transform a string.
#' @param opcodes A data frame of opcode transformations (type, src_begin, src_end, dest_begin, dest_end).
#' @param s1 The source string.
#' @param s2 The target string.
#' @return The transformed string.
#' @export
opcodes_apply_str <- function(opcodes, s1, s2) {
    .Call(`_RapidFuzz_opcodes_apply_str`, opcodes, s1, s2)
}

#' @title Apply Opcodes to Vector
#' @description Applies opcodes to transform a string.
#' @param opcodes A data frame of opcode transformations (type, src_begin, src_end, dest_begin, dest_end).
#' @param s1 The source string.
#' @param s2 The target string.
#' @return A character vector representing the transformed string.
#' @export
opcodes_apply_vec <- function(opcodes, s1, s2) {
    .Call(`_RapidFuzz_opcodes_apply_vec`, opcodes, s1, s2)
}

#' @title Apply Edit Operations to Vector
#' @description Applies edit operations to transform a string.
#' @param editops A data frame of edit operations (type, src_pos, dest_pos).
#' @param s1 The source string.
#' @param s2 The target string.
#' @return A character vector representing the transformed string.
#' @export
editops_apply_vec <- function(editops, s1, s2) {
    .Call(`_RapidFuzz_editops_apply_vec`, editops, s1, s2)
}

#' @name processString
#' @title Process a String
#' @description Processes a given input string by applying optional trimming, case conversion, and ASCII transliteration.
#' @param input A \code{std::string} representing the input string to be processed.
#' @param processor A \code{bool} indicating whether to trim whitespace and convert the string to lowercase. Default is \code{true}.
#' @param asciify A \code{bool} indicating whether to transliterate non-ASCII characters to their closest ASCII equivalents. Default is \code{false}.
#' @details
#' The function applies the following transformations to the input string, in this order:
#' \itemize{
#'   \item \strong{Trimming (if \code{processor = TRUE}):} Removes leading and trailing whitespace.
#'   \item \strong{Lowercasing (if \code{processor = TRUE}):} Converts all characters to lowercase.
#'   \item \strong{ASCII Transliteration (if \code{asciify = TRUE}):} Replaces accented or special characters with their closest ASCII equivalents.
#' }
#' @return A \code{std::string} representing the processed string.
#' @examples
#' # Example usage
#' processString("  Éxâmple!  ", processor = TRUE, asciify = TRUE)
#' # Returns: "example!"
#'
#' processString("  Éxâmple!  ", processor = TRUE, asciify = FALSE)
#' # Returns: "éxâmple!"
#'
#' processString("  Éxâmple!  ", processor = FALSE, asciify = TRUE)
#' # Returns: "Éxâmple!"
#'
#' processString("  Éxâmple!  ", processor = FALSE, asciify = FALSE)
#' # Returns: "  Éxâmple!  "
#' @export
processString <- function(input, processor = TRUE, asciify = FALSE) {
    .Call(`_RapidFuzz_processString`, input, processor, asciify)
}

#' @name extract_similar_strings
#' @title Extract Matches
#' @description Compares a query string to all strings in a list of choices and returns all elements
#' with a similarity score above the score_cutoff.
#' @param query The query string to compare.
#' @param choices A vector of strings to compare against the query.
#' @param score_cutoff A numeric value specifying the minimum similarity score (default is 50.0).
#' @param processor A boolean indicating whether to preprocess strings before comparison (default is TRUE).
#' @return A data frame containing matched strings and their similarity scores.
#' @export
extract_similar_strings <- function(query, choices, score_cutoff = 50.0, processor = TRUE) {
    .Call(`_RapidFuzz_extract_similar_strings`, query, choices, score_cutoff, processor)
}

#' @name extract_best_match
#' @title Extract Best Match
#' @description Compares a query string to all strings in a list of choices and returns the best match
#' with a similarity score above the score_cutoff.
#' @param query The query string to compare.
#' @param choices A vector of strings to compare against the query.
#' @param score_cutoff A numeric value specifying the minimum similarity score (default is 50.0).
#' @param processor A boolean indicating whether to preprocess strings before comparison (default is TRUE).
#' @return A list containing the best matching string and its similarity score.
#' @export
extract_best_match <- function(query, choices, score_cutoff = 50.0, processor = TRUE) {
    .Call(`_RapidFuzz_extract_best_match`, query, choices, score_cutoff, processor)
}

#' @name extract_matches
#' @title Extract Matches with Scoring and Limit
#' @description Compares a query string to a list of choices using the specified scorer and returns
#' the top matches with a similarity score above the cutoff.
#' @param query The query string to compare.
#' @param choices A vector of strings to compare against the query.
#' @param score_cutoff A numeric value specifying the minimum similarity score (default is 50.0).
#' @param limit The maximum number of matches to return (default is 3).
#' @param processor A boolean indicating whether to preprocess strings before comparison (default is TRUE).
#' @param scorer A string specifying the similarity scoring method ("WRatio", "Ratio", "PartialRatio", etc.).
#' @return A data frame containing the top matched strings and their similarity scores.
#' @export
extract_matches <- function(query, choices, score_cutoff = 50.0, limit = 3L, processor = TRUE, scorer = "WRatio") {
    .Call(`_RapidFuzz_extract_matches`, query, choices, score_cutoff, limit, processor, scorer)
}

#' @name fuzz_ratio
#' @title Simple Ratio Calculation
#' @description Calculates a simple ratio between two strings.
#' @param s1 First string.
#' @param s2 Second string.
#' @param score_cutoff Optional score cutoff threshold (default: 0.0).
#' @return A double representing the ratio between the two strings.
#' @examples
#' fuzz_ratio("this is a test", "this is a test!")
#' @export
fuzz_ratio <- function(s1, s2, score_cutoff = 0.0) {
    .Call(`_RapidFuzz_fuzz_ratio`, s1, s2, score_cutoff)
}

#' @name fuzz_partial_ratio
#' @title Partial Ratio Calculation
#' @description Calculates a partial ratio between two strings, which ignores long mismatching substrings.
#' @param s1 First string.
#' @param s2 Second string.
#' @param score_cutoff Optional score cutoff threshold (default: 0.0).
#' @return A double representing the partial ratio between the two strings.
#' @examples
#' fuzz_partial_ratio("this is a test", "this is a test!")
#' @export
fuzz_partial_ratio <- function(s1, s2, score_cutoff = 0.0) {
    .Call(`_RapidFuzz_fuzz_partial_ratio`, s1, s2, score_cutoff)
}

#' @name fuzz_token_sort_ratio
#' @title Token Sort Ratio Calculation
#' @description Sorts the words in the strings and calculates the ratio between them.
#' @param s1 First string.
#' @param s2 Second string.
#' @param score_cutoff Optional score cutoff threshold (default: 0.0).
#' @return A double representing the token sort ratio between the two strings.
#' @examples
#' fuzz_token_sort_ratio("fuzzy wuzzy was a bear", "wuzzy fuzzy was a bear")
#' @export
fuzz_token_sort_ratio <- function(s1, s2, score_cutoff = 0.0) {
    .Call(`_RapidFuzz_fuzz_token_sort_ratio`, s1, s2, score_cutoff)
}

#' @name fuzz_token_set_ratio
#' @title Token Set Ratio Calculation
#' @description Compares the unique and common words in the strings and calculates the ratio.
#' @param s1 First string.
#' @param s2 Second string.
#' @param score_cutoff Optional score cutoff threshold (default: 0.0).
#' @return A double representing the token set ratio between the two strings.
#' @examples
#' fuzz_token_set_ratio("fuzzy wuzzy was a bear", "fuzzy fuzzy was a bear")
#' @export
fuzz_token_set_ratio <- function(s1, s2, score_cutoff = 0.0) {
    .Call(`_RapidFuzz_fuzz_token_set_ratio`, s1, s2, score_cutoff)
}

#' @name fuzz_token_ratio
#' @title Combined Token Ratio
#' @description Calculates the maximum ratio of token set ratio and token sort ratio.
#' @param s1 First string.
#' @param s2 Second string.
#' @param score_cutoff Optional score cutoff threshold (default: 0.0).
#' @return A double representing the combined token ratio between the two strings.
#' @examples
#' fuzz_token_ratio("fuzzy wuzzy was a bear", "wuzzy fuzzy was a bear")
#' @export
fuzz_token_ratio <- function(s1, s2, score_cutoff = 0.0) {
    .Call(`_RapidFuzz_fuzz_token_ratio`, s1, s2, score_cutoff)
}

#' @name fuzz_WRatio
#' @title Weighted Ratio Calculation
#' @description Calculates a weighted ratio based on other ratio algorithms.
#' @param s1 First string.
#' @param s2 Second string.
#' @param score_cutoff Optional score cutoff threshold (default: 0.0).
#' @return A double representing the weighted ratio between the two strings.
#' @examples
#' fuzz_WRatio("this is a test", "this is a test!")
#' @export
fuzz_WRatio <- function(s1, s2, score_cutoff = 0.0) {
    .Call(`_RapidFuzz_fuzz_WRatio`, s1, s2, score_cutoff)
}

#' @name fuzz_QRatio
#' @title Quick Ratio Calculation
#' @description Calculates a quick ratio using fuzz ratio.
#' @param s1 First string.
#' @param s2 Second string.
#' @param score_cutoff Optional score cutoff threshold (default: 0.0).
#' @return A double representing the quick ratio between the two strings.
#' @examples
#' fuzz_QRatio("this is a test", "this is a test!")
#' @export
fuzz_QRatio <- function(s1, s2, score_cutoff = 0.0) {
    .Call(`_RapidFuzz_fuzz_QRatio`, s1, s2, score_cutoff)
}

#' @name hamming_distance
#' @title Hamming Distance
#' @description Calculates the Hamming distance between two strings.
#' @param s1 The first string.
#' @param s2 The second string.
#' @param pad If true, the strings are padded to the same length (default: TRUE).
#' @return An integer representing the Hamming distance.
#' @examples
#' hamming_distance("karolin", "kathrin")
#' @export
hamming_distance <- function(s1, s2, pad = TRUE) {
    .Call(`_RapidFuzz_hamming_distance`, s1, s2, pad)
}

#' @name hamming_similarity
#' @title Hamming Similarity
#' @description Measures the similarity between two strings using the Hamming metric.
#' @param s1 The first string.
#' @param s2 The second string.
#' @param pad If true, the strings are padded to the same length (default: TRUE).
#' @return An integer representing the similarity.
#' @examples
#' hamming_similarity("karolin", "kathrin")
#' @export
hamming_similarity <- function(s1, s2, pad = TRUE) {
    .Call(`_RapidFuzz_hamming_similarity`, s1, s2, pad)
}

#' @name hamming_normalized_distance
#' @title Normalized Hamming Distance
#' @description Calculates the normalized Hamming distance between two strings.
#' @param s1 The first string.
#' @param s2 The second string.
#' @param pad If true, the strings are padded to the same length (default: TRUE).
#' @return A value between 0 and 1 representing the normalized distance.
#' @examples
#' hamming_normalized_distance("karolin", "kathrin")
#' @export
hamming_normalized_distance <- function(s1, s2, pad = TRUE) {
    .Call(`_RapidFuzz_hamming_normalized_distance`, s1, s2, pad)
}

#' @name hamming_normalized_similarity
#' @title Normalized Hamming Similarity
#' @description Calculates the normalized Hamming similarity between two strings.
#' @param s1 The first string.
#' @param s2 The second string.
#' @param pad If true, the strings are padded to the same length (default: TRUE).
#' @return A value between 0 and 1 representing the normalized similarity.
#' @examples
#' hamming_normalized_similarity("karolin", "kathrin")
#' @export
hamming_normalized_similarity <- function(s1, s2, pad = TRUE) {
    .Call(`_RapidFuzz_hamming_normalized_similarity`, s1, s2, pad)
}

#' @name indel_distance
#' @title Indel Distance
#' @description Calculates the insertion/deletion (Indel) distance between two strings.
#' @param s1 The first string.
#' @param s2 The second string.
#' @return A numeric value representing the Indel distance.
#' @examples
#' indel_distance("kitten", "sitting")
#' @export
indel_distance <- function(s1, s2) {
    .Call(`_RapidFuzz_indel_distance`, s1, s2)
}

#' @name indel_normalized_distance
#' @title Normalized Indel Distance
#' @description Calculates the normalized insertion/deletion (Indel) distance between two strings.
#' @param s1 The first string.
#' @param s2 The second string.
#' @return A numeric value between 0 and 1 representing the normalized Indel distance.
#' @examples
#' indel_normalized_distance("kitten", "sitting")
#' @export
indel_normalized_distance <- function(s1, s2) {
    .Call(`_RapidFuzz_indel_normalized_distance`, s1, s2)
}

#' @name indel_similarity
#' @title Indel Similarity
#' @description Calculates the insertion/deletion (Indel) similarity between two strings.
#' @param s1 The first string.
#' @param s2 The second string.
#' @return A numeric value representing the Indel similarity.
#' @examples
#' indel_similarity("kitten", "sitting")
#' @export
indel_similarity <- function(s1, s2) {
    .Call(`_RapidFuzz_indel_similarity`, s1, s2)
}

#' @name indel_normalized_similarity
#' @title Normalized Indel Similarity
#' @description Calculates the normalized insertion/deletion (Indel) similarity between two strings.
#' @param s1 The first string.
#' @param s2 The second string.
#' @return A numeric value between 0 and 1 representing the normalized Indel similarity.
#' @examples
#' indel_normalized_similarity("kitten", "sitting")
#' @export
indel_normalized_similarity <- function(s1, s2) {
    .Call(`_RapidFuzz_indel_normalized_similarity`, s1, s2)
}

#' @name jaro_distance
#' @title Jaro Distance
#' @description Calculates the Jaro distance between two strings, a value between 0 and 1.
#' @param s1 The first string.
#' @param s2 The second string.
#' @return A numeric value representing the Jaro distance.
#' @examples
#' jaro_distance("kitten", "sitting")
#' @export
jaro_distance <- function(s1, s2) {
    .Call(`_RapidFuzz_jaro_distance`, s1, s2)
}

#' @name jaro_similarity
#' @title Jaro Similarity
#' @description Calculates the Jaro similarity between two strings, a value between 0 and 1.
#' @param s1 The first string.
#' @param s2 The second string.
#' @return A numeric value representing the Jaro similarity.
#' @examples
#' jaro_similarity("kitten", "sitting")
#' @export
jaro_similarity <- function(s1, s2) {
    .Call(`_RapidFuzz_jaro_similarity`, s1, s2)
}

#' @name jaro_normalized_distance
#' @title Normalized Jaro Distance
#' @description Calculates the normalized Jaro distance between two strings, a value between 0 and 1.
#' @param s1 The first string.
#' @param s2 The second string.
#' @return A numeric value representing the normalized Jaro distance.
#' @examples
#' jaro_normalized_distance("kitten", "sitting")
#' @export
jaro_normalized_distance <- function(s1, s2) {
    .Call(`_RapidFuzz_jaro_normalized_distance`, s1, s2)
}

#' @name jaro_normalized_similarity
#' @title Normalized Jaro Similarity
#' @description Calculates the normalized Jaro similarity between two strings, a value between 0 and 1.
#' @param s1 The first string.
#' @param s2 The second string.
#' @return A numeric value representing the normalized Jaro similarity.
#' @examples
#' jaro_normalized_similarity("kitten", "sitting")
#' @export
jaro_normalized_similarity <- function(s1, s2) {
    .Call(`_RapidFuzz_jaro_normalized_similarity`, s1, s2)
}

#' @name jaro_winkler_distance
#' @title Jaro-Winkler Distance
#' @description Calculates the Jaro-Winkler distance between two strings.
#' @param s1 The first string.
#' @param s2 The second string.
#' @param prefix_weight The weight applied to the prefix (default: 0.1).
#' @return A numeric value representing the Jaro-Winkler distance.
#' @examples
#' jaro_winkler_distance("kitten", "sitting")
#' @export
jaro_winkler_distance <- function(s1, s2, prefix_weight = 0.1) {
    .Call(`_RapidFuzz_jaro_winkler_distance`, s1, s2, prefix_weight)
}

#' @name jaro_winkler_similarity
#' @title Jaro-Winkler Similarity
#' @description Calculates the Jaro-Winkler similarity between two strings.
#' @param s1 The first string.
#' @param s2 The second string.
#' @param prefix_weight The weight applied to the prefix (default: 0.1).
#' @return A numeric value representing the Jaro-Winkler similarity.
#' @examples
#' jaro_winkler_similarity("kitten", "sitting")
#' @export
jaro_winkler_similarity <- function(s1, s2, prefix_weight = 0.1) {
    .Call(`_RapidFuzz_jaro_winkler_similarity`, s1, s2, prefix_weight)
}

#' @name jaro_winkler_normalized_distance
#' @title Normalized Jaro-Winkler Distance
#' @description Calculates the normalized Jaro-Winkler distance between two strings.
#' @param s1 The first string.
#' @param s2 The second string.
#' @param prefix_weight The weight applied to the prefix (default: 0.1).
#' @return A numeric value representing the normalized Jaro-Winkler distance.
#' @examples
#' jaro_winkler_normalized_distance("kitten", "sitting")
#' @export
jaro_winkler_normalized_distance <- function(s1, s2, prefix_weight = 0.1) {
    .Call(`_RapidFuzz_jaro_winkler_normalized_distance`, s1, s2, prefix_weight)
}

#' @name jaro_winkler_normalized_similarity
#' @title Similaridade Normalizada Jaro-Winkler
#' @description Calcula a similaridade normalizada Jaro-Winkler entre duas strings.
#' @param s1 Primeira string.
#' @param s2 Segunda string.
#' @param prefix_weight Peso do prefixo (valor padrão: 0.1).
#' @return Um valor numérico representando a similaridade normalizada Jaro-Winkler.
#' @examples
#' jaro_winkler_normalized_similarity("kitten", "sitting")
#' @export
jaro_winkler_normalized_similarity <- function(s1, s2, prefix_weight = 0.1) {
    .Call(`_RapidFuzz_jaro_winkler_normalized_similarity`, s1, s2, prefix_weight)
}

#' @name lcs_seq_distance
#' @title LCSseq Distance
#' @description Calculates the LCSseq (Longest Common Subsequence) distance between two strings.
#' @param s1 The first string.
#' @param s2 The second string.
#' @param score_cutoff Score threshold to stop calculation. Default is the maximum possible value.
#' @return A numeric value representing the LCSseq distance.
#' @examples
#' lcs_seq_distance("kitten", "sitting")
#' @export
lcs_seq_distance <- function(s1, s2, score_cutoff = NULL) {
    .Call(`_RapidFuzz_lcs_seq_distance`, s1, s2, score_cutoff)
}

#' @name lcs_seq_similarity
#' @title LCSseq Similarity
#' @description Calculates the LCSseq similarity between two strings.
#' @param s1 The first string.
#' @param s2 The second string.
#' @param score_cutoff Score threshold to stop calculation. Default is 0.
#' @return A numeric value representing the LCSseq similarity.
#' @examples
#' lcs_seq_similarity("kitten", "sitting")
#' @export
lcs_seq_similarity <- function(s1, s2, score_cutoff = 0L) {
    .Call(`_RapidFuzz_lcs_seq_similarity`, s1, s2, score_cutoff)
}

#' @name lcs_seq_normalized_distance
#' @title Normalized LCSseq Distance
#' @description Calculates the normalized LCSseq distance between two strings.
#' @param s1 The first string.
#' @param s2 The second string.
#' @param score_cutoff Score threshold to stop calculation. Default is 1.0.
#' @return A numeric value representing the normalized LCSseq distance.
#' @examples
#' lcs_seq_normalized_distance("kitten", "sitting")
#' @export
lcs_seq_normalized_distance <- function(s1, s2, score_cutoff = 1.0) {
    .Call(`_RapidFuzz_lcs_seq_normalized_distance`, s1, s2, score_cutoff)
}

#' @name lcs_seq_normalized_similarity
#' @title Normalized LCSseq Similarity
#' @description Calculates the normalized LCSseq similarity between two strings.
#' @param s1 The first string.
#' @param s2 The second string.
#' @param score_cutoff Score threshold to stop calculation. Default is 0.0.
#' @return A numeric value representing the normalized LCSseq similarity.
#' @examples
#' lcs_seq_normalized_similarity("kitten", "sitting")
#' @export
lcs_seq_normalized_similarity <- function(s1, s2, score_cutoff = 0.0) {
    .Call(`_RapidFuzz_lcs_seq_normalized_similarity`, s1, s2, score_cutoff)
}

#' @name lcs_seq_editops
#' @title LCSseq Edit Operations
#' @description Calculates the edit operations required to transform one string into another.
#' @param s1 The first string.
#' @param s2 The second string.
#' @return A data.frame containing the edit operations (substitutions, insertions, and deletions).
#' @examples
#' lcs_seq_editops("kitten", "sitting")
#' @export
lcs_seq_editops <- function(s1, s2) {
    .Call(`_RapidFuzz_lcs_seq_editops`, s1, s2)
}

#' @name levenshtein_distance
#' @title Levenshtein Distance
#' @description
#' Calculates the Levenshtein distance between two strings, which represents the minimum number
#' of insertions, deletions, and substitutions required to transform one string into the other.
#'
#' @param s1 The first string.
#' @param s2 The second string.
#' @return A numeric value representing the Levenshtein distance.
#' @examples
#' levenshtein_distance("kitten", "sitting")
#' @export
levenshtein_distance <- function(s1, s2) {
    .Call(`_RapidFuzz_levenshtein_distance`, s1, s2)
}

#' @name levenshtein_normalized_distance
#' @title Normalized Levenshtein Distance
#' @description
#' The normalized Levenshtein distance is the Levenshtein distance divided by the maximum length of the
#' compared strings, returning a value between 0 and 1.
#'
#' @param s1 The first string.
#' @param s2 The second string.
#' @return A numeric value representing the normalized Levenshtein distance.
#' @examples
#' levenshtein_normalized_distance("kitten", "sitting")
#' @export
levenshtein_normalized_distance <- function(s1, s2) {
    .Call(`_RapidFuzz_levenshtein_normalized_distance`, s1, s2)
}

#' @name levenshtein_similarity
#' @title Levenshtein Similarity
#' @description
#' Levenshtein similarity measures how similar two strings are, based on the minimum number
#' of operations required to make them identical.
#'
#' @param s1 The first string.
#' @param s2 The second string.
#' @return A numeric value representing the Levenshtein similarity.
#' @examples
#' levenshtein_similarity("kitten", "sitting")
#' @export
levenshtein_similarity <- function(s1, s2) {
    .Call(`_RapidFuzz_levenshtein_similarity`, s1, s2)
}

#' @name levenshtein_normalized_similarity
#' @title Normalized Levenshtein Similarity
#' @description
#' The normalized Levenshtein similarity returns a value between 0 and 1,
#' indicating how similar the compared strings are.
#'
#' @param s1 The first string.
#' @param s2 The second string.
#' @return A numeric value representing the normalized Levenshtein similarity.
#' @examples
#' levenshtein_normalized_similarity("kitten", "sitting")
#' @export
levenshtein_normalized_similarity <- function(s1, s2) {
    .Call(`_RapidFuzz_levenshtein_normalized_similarity`, s1, s2)
}

#' @name osa_normalized_similarity
#' @title Normalized Similarity Using OSA
#' @description Calculates the normalized similarity between two strings using the Optimal String Alignment (OSA) algorithm.
#' @param s1 A string to compare.
#' @param s2 Another string to compare.
#' @param score_cutoff A threshold for the normalized similarity score (default is 0.0).
#' @return A double representing the normalized similarity score.
#' @examples
#' osa_normalized_similarity("string1", "string2")
#' @export
osa_normalized_similarity <- function(s1, s2, score_cutoff = 0.0) {
    .Call(`_RapidFuzz_osa_normalized_similarity`, s1, s2, score_cutoff)
}

#' @name osa_editops
#' @title Edit Operations Using OSA
#' @description Provides the edit operations required to transform one string into another using the OSA algorithm.
#' @param s1 A string to transform.
#' @param s2 A target string.
#' @return A data frame with the following columns:
#' \describe{
#'   \item{operation}{The type of operation (delete, insert, replace).}
#'   \item{source_position}{The position in the source string.}
#'   \item{destination_position}{The position in the target string.}
#' }
#' @examples
#' osa_editops("string1", "string2")
#' @export
osa_editops <- function(s1, s2) {
    .Call(`_RapidFuzz_osa_editops`, s1, s2)
}

#' @name osa_distance
#' @title Distance Using OSA
#' @description Calculates the OSA distance between two strings.
#' @param s1 A string to compare.
#' @param s2 Another string to compare.
#' @param score_cutoff A threshold for the distance score (default is the maximum possible size_t value).
#' @return An integer representing the OSA distance.
#' @examples
#' osa_distance("string1", "string2")
#' @export
osa_distance <- function(s1, s2, score_cutoff = NULL) {
    .Call(`_RapidFuzz_osa_distance`, s1, s2, score_cutoff)
}

#' @name osa_similarity
#' @title Similarity Using OSA
#' @description Calculates the OSA similarity between two strings.
#' @param s1 A string to compare.
#' @param s2 Another string to compare.
#' @param score_cutoff A threshold for the similarity score (default is 0).
#' @return An integer representing the OSA similarity.
#' @examples
#' osa_similarity("string1", "string2")
#' @export
osa_similarity <- function(s1, s2, score_cutoff = 0L) {
    .Call(`_RapidFuzz_osa_similarity`, s1, s2, score_cutoff)
}

#' @name osa_normalized_distance
#' @title Normalized Distance Using OSA
#' @description Calculates the normalized OSA distance between two strings.
#' @param s1 A string to compare.
#' @param s2 Another string to compare.
#' @param score_cutoff A threshold for the normalized distance score (default is 1.0).
#' @return A double representing the normalized distance score.
#' @examples
#' osa_normalized_distance("string1", "string2")
#' @export
osa_normalized_distance <- function(s1, s2, score_cutoff = 1.0) {
    .Call(`_RapidFuzz_osa_normalized_distance`, s1, s2, score_cutoff)
}

#'
#' @title Postfix Distance
#' @description Calculates the distance between the postfixes of two strings.
#'
#' @param s1 A string to compare.
#' @param s2 Another string to compare.
#' @param score_cutoff A threshold for the distance score (default is the maximum possible size_t value).
#'
#' @return An integer representing the postfix distance.
#'
#' @examples
#' postfix_distance("string1", "string2")
postfix_distance <- function(s1, s2, score_cutoff = NULL) {
    .Call(`_RapidFuzz_postfix_distance`, s1, s2, score_cutoff)
}

#' @title Postfix Similarity
#' @description Calculates the similarity between the postfixes of two strings.
#'
#' @param s1 A string to compare.
#' @param s2 Another string to compare.
#' @param score_cutoff A threshold for the similarity score (default is 0).
#'
#' @return An integer representing the postfix similarity.
#'
#' @examples
#' postfix_similarity("string1", "string2")
postfix_similarity <- function(s1, s2, score_cutoff = 0L) {
    .Call(`_RapidFuzz_postfix_similarity`, s1, s2, score_cutoff)
}

#' @title Normalized Postfix Distance
#' @description Calculates the normalized distance between the postfixes of two strings.
#'
#' @param s1 A string to compare.
#' @param s2 Another string to compare.
#' @param score_cutoff A threshold for the normalized distance score (default is 1.0).
#'
#' @return A double representing the normalized postfix distance.
#'
#' @examples
#' postfix_normalized_distance("string1", "string2")
postfix_normalized_distance <- function(s1, s2, score_cutoff = 1.0) {
    .Call(`_RapidFuzz_postfix_normalized_distance`, s1, s2, score_cutoff)
}

#' @title Normalized Postfix Similarity
#' @description Calculates the normalized similarity between the postfixes of two strings.
#'
#' @param s1 A string to compare.
#' @param s2 Another string to compare.
#' @param score_cutoff A threshold for the normalized similarity score (default is 0.0).
#'
#' @return A double representing the normalized postfix similarity.
#'
#' @examples
#' postfix_normalized_similarity("string1", "string2")
postfix_normalized_similarity <- function(s1, s2, score_cutoff = 0.0) {
    .Call(`_RapidFuzz_postfix_normalized_similarity`, s1, s2, score_cutoff)
}

#' Calculate the prefix distance between two strings
#'
#' Computes the prefix distance, which measures the number of character edits required to convert
#' one prefix into another. This includes insertions, deletions, and substitutions.
#'
#' @param s1 A string. The first input string.
#' @param s2 A string. The second input string.
#' @param score_cutoff An optional maximum threshold for the distance. Defaults to the largest
#' integer value in R (`.Machine$integer.max`).
#' @return The prefix distance as an integer.
#' @examples
#' prefix_distance("abcdef", "abcxyz")
#' prefix_distance("abcdef", "abcxyz", score_cutoff = 3)
#' @export
prefix_distance <- function(s1, s2, score_cutoff = NULL) {
    .Call(`_RapidFuzz_prefix_distance`, s1, s2, score_cutoff)
}

#' Calculate the prefix similarity between two strings
#'
#' Computes the similarity of the prefixes of two strings based on their number of matching characters.
#'
#' @param s1 A string. The first input string.
#' @param s2 A string. The second input string.
#' @param score_cutoff An optional minimum threshold for the similarity score. Defaults to 0.
#' @return The prefix similarity as an integer.
#' @examples
#' prefix_similarity("abcdef", "abcxyz")
#' prefix_similarity("abcdef", "abcxyz", score_cutoff = 3)
#' @export
prefix_similarity <- function(s1, s2, score_cutoff = 0L) {
    .Call(`_RapidFuzz_prefix_similarity`, s1, s2, score_cutoff)
}

#' Calculate the normalized prefix distance between two strings
#'
#' Computes the normalized distance of the prefixes of two strings, where the result is between
#' 0.0 (identical) and 1.0 (completely different).
#'
#' @param s1 A string. The first input string.
#' @param s2 A string. The second input string.
#' @param score_cutoff An optional maximum threshold for the normalized distance. Defaults to 1.0.
#' @return The normalized prefix distance as a double.
#' @examples
#' prefix_normalized_distance("abcdef", "abcxyz")
#' prefix_normalized_distance("abcdef", "abcxyz", score_cutoff = 0.5)
#' @export
prefix_normalized_distance <- function(s1, s2, score_cutoff = 1.0) {
    .Call(`_RapidFuzz_prefix_normalized_distance`, s1, s2, score_cutoff)
}

#' Calculate the normalized prefix similarity between two strings
#'
#' Computes the normalized similarity of the prefixes of two strings, where the result is between
#' 0.0 (completely different) and 1.0 (identical).
#'
#' @param s1 A string. The first input string.
#' @param s2 A string. The second input string.
#' @param score_cutoff An optional minimum threshold for the normalized similarity. Defaults to 0.0.
#' @return The normalized prefix similarity as a double.
#' @examples
#' prefix_normalized_similarity("abcdef", "abcxyz")
#' prefix_normalized_similarity("abcdef", "abcxyz", score_cutoff = 0.7)
#' @export
prefix_normalized_similarity <- function(s1, s2, score_cutoff = 0.0) {
    .Call(`_RapidFuzz_prefix_normalized_similarity`, s1, s2, score_cutoff)
}

