% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Raquifer_package.R
\name{aquifer_time}
\alias{aquifer_time}
\title{A list object of class 'time' for aquifer models}
\usage{
aquifer_time(x, unit = "day")
}
\arguments{
\item{x}{a vector of times or a daily sequence of dates}

\item{unit}{time/date unit of vector x}
}
\value{
a list of class 'time' with all the required parameters for the aquifer_predict() S3 methods
}
\description{
Create an object of class 'time'
}
\examples{
aquifer_time_1 <- aquifer_time(c(0:4) * 365, unit = "day")

aquifer_time_1

aquifer_time_2 <- aquifer_time(c(0:4), unit = "month")

aquifer_time_2

aquifer_time_3 <- aquifer_time(c(0:4), unit = "year")

aquifer_time_3

aquifer_time_4 <- aquifer_time(seq(as.Date("2020/1/1"), by = "year",
length.out = 5), unit = "date")

aquifer_time_4
}
