% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intermediate_header.R
\name{intermediate_header}
\alias{intermediate_header}
\title{Intermediate Header}
\usage{
intermediate_header(
  tbls,
  group_header,
  color = "#8ECAE6",
  size = 16,
  align = "center",
  weight = "bold"
)
}
\arguments{
\item{tbls}{A list of descriptive tables (generated by \code{RastaRocket::desc_var} or similar functions).}

\item{group_header}{A character vector specifying the headers for each group of tables.
Must be the same length as \code{tbls}.}

\item{color}{A character string specifying the background color for the row group headers.
Default is \code{"#8ECAE6"}.}

\item{size}{An integer specifying the font size for the row group headers. Default is \code{16}.}

\item{align}{A character string specifying text alignment for the row group headers.
Options are \code{"left"}, \code{"center"}, or \code{"right"}. Default is \code{"center"}.}

\item{weight}{A character string specifying the font weight for the row group headers.
Options include \code{"normal"}, \code{"bold"}, etc. Default is \code{"bold"}.}
}
\value{
A styled \code{gt} table combining the input tables with row group headers.
}
\description{
Combines multiple descriptive tables into a single table with customized row group headers and styling.
This function accepts a list of tables and corresponding group headers, applies consistent styling,
and outputs a styled \code{gt} table.
}
\examples{
# Load necessary libraries
library(RastaRocket)
library(dplyr)

# Generate sample data
data <- data.frame(
  Age = c(rnorm(45, mean = 50, sd = 10), rep(NA, 5)),
  sexe = sample(c("Femme", "Homme"), 50, replace = TRUE, prob = c(0.6, 0.4)),
  quatre_modalites = sample(c("A", "B", "C", "D"), 50, replace = TRUE)
)

# Create descriptive tables
tb1 <- data \%>\%
  dplyr::select(Age, sexe) \%>\%
  RastaRocket::desc_var(table_title = "Demographics", group = FALSE)

tb2 <- data \%>\%
  dplyr::select(quatre_modalites) \%>\%
  RastaRocket::desc_var(table_title = "Modalities", group = FALSE)

# Combine and style tables
intermediate_header(
  tbls = list(tb1, tb2),
  group_header = c("Demographics", "Modalities")
)
}
