% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blpAuthenticate.R
\name{blpAuthenticate}
\alias{blpAuthenticate}
\title{Authenticate Bloomberg API access}
\usage{
blpAuthenticate(uuid = getOption("blpUUID", NULL),
  host = getOption("blpLoginHostname", "localhost"),
  ip.address = getOption("blpLoginIP", NULL), con = defaultConnection(),
  default = TRUE, isAuthId = getOption("blpIsAuthId", FALSE),
  appName = getOption("blpAppName", NULL))
}
\arguments{
\item{uuid}{An optional character variable with a unique user id
token. If this is missing the function will attempt to connect
to B-PIPE or SAPI using the connection. It is assumed that an
app_name was set. See \code{blpConnect()} for app_name
information.  Defaults to \code{getOption("blpUUID")} or NULL}

\item{host}{An optional character variable with a hostname.  This is
the hostname of the machine where the user last authenticated.
Either host or ip.address should be provided for user/uuid
authentication. Note this is likely not the same 'host' used in
\code{blpConnect()}.  Defaults to
\code{getOption("blpLoginHostname")} or "localhost"}

\item{ip.address}{An optional character variable with an IP address
for authentication.  Usually the IP address where the uuid/user
last logged into the Bloomberg Terminal appication.  Defaults to
\code{getOption("blpLoginIP")} or NULL, which will then lookup
the IP of the "host" option.}

\item{con}{A connection object as created by a \code{blpConnect}
call, and retrieved via the internal function. This is the only required
argument to authenticate a B-PIPE connection with a appName.
Defaults to \code{defaultConnection}.}

\item{default}{A logical indicating whether this authentication should
be saved as the default, as opposed to returned to the
user. Default to \code{TRUE}.}

\item{isAuthId}{A logical indicating whether to interpret the uuid
as an authId for authenticating a user with a B-PIPE application.}

\item{appName}{If isAuthId is TRUE, this is a character string
associated with the B-PIPE application name. This will be the same
appName used by \code{blpConnect()}. If isAuthId is FALSE,
this will be ignored.}
}
\value{
In the \code{default=TRUE} case nothing is returned, and
this authentication is automatically used for all future calls which
omit the \code{identity} argument. Otherwise an authentication object is
returned which is required by all the accessor functions in the
package. (e.g. \code{bdp()} \code{bds()} \code{getPortfolio()}
}
\description{
This function authenticates against the the Bloomberg API
}
\examples{
\dontrun{
blpConnect(host=blpHost, port=blpPort)
blpAuthenticate(uuid=blpUUID, ip=blpIP_address)
bdp("IBM US Equity", "NAME")

blpid <- blpAuthenticate(uuid=blpUUID, ip=blpIP_address)
bdp("IBM US Equity", "NAME", identity=blpid)
}
}
\author{
Whit Armstrong and Dirk Eddelbuettel
}
