% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{col_mut_info_vec}
\alias{col_mut_info_vec}
\title{Vectorized version of function col_mut_info}
\usage{
col_mut_info_vec(x, y, args = NULL)
}
\arguments{
\item{x}{List, where each element is an input to \code{x} in \code{\link{col_mut_info}}.}

\item{y}{List, where each element is an input to \code{y} in \code{\link{col_mut_info}}.}

\item{args}{\code{NULL} (default) or list where each element is an input to \code{args}
in \code{\link{col_mut_info}}.}
}
\value{
List, where each element is an output from \code{\link{col_mut_info}}.
}
\description{
This is the vectorized version of \code{\link{col_mut_info}}.
}
\note{
Change log:
\itemize{
\item{0.1.0 Xiurui Zhu - Initiate the function.}
}
}
\examples{
if (require("MASS", quietly = TRUE) == TRUE) {
  data(cats)
  print(res_cpp <- col_mut_info_vec(list(round(cats[, 2L:3L])), list(cats[, 1L])))
  # Validate with caTools::colAUC()
  if ((require("infotheo", quietly = TRUE) == TRUE) &&
      (require("magrittr", quietly = TRUE) == TRUE)) {
    print(res_r <- sapply(round(cats[, 2L:3L]), infotheo::mutinformation, cats[, 1L]) \%>\%
            {matrix(., nrow = 1L, dimnames = list(NULL, names(.)))})
    identical(res_cpp, list(res_r))
  }
}
}
\seealso{
\code{\link{col_mut_info}} for the non-vectorized version.
}
