\name{initHMM}
\alias{initHMM}

\title{
Random Initialization for a Hidden Markov Model with emissions modeled as categorical variables
}

\description{
Function used to generate a hidden Markov model with categorical variables and random parameters. The code for the methods with continuous values or discrete data can be viewed in \code{"\link{initGHMM}"} and \code{"\link{initPHMM}"}, respectively.  
}

\usage{
initHMM(n, m)
}

\arguments{
  \item{n}{the number of hidden states to use.}
  \item{m}{the number of possible categories (labels) generated by the hidden states.}
}

\value{
A \code{"\link{list}"} that contains the required values to specify the model.
\item{Model}{it specifies that the observed values are to be modeled as a multinomial distribution.}
\item{StateNames}{the set of hidden state names.}
\item{ObservationNames}{the set of possible observed values.}
\item{A}{the transition probabilities matrix.} 
\item{B}{the emission probabilities matrix.} 
\item{Pi}{the initial probability vector.}
}

\references{
Cited references are listed on the \link{RcppHMM} manual page.
}

\examples{
n <- 2
m <- 2
model <- initHMM(n,m)
print(model)
}

\keyword{initialization}
