% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcssGet.R
\name{RcssProperty}
\alias{RcssProperty}
\title{Extract information about property and its value}
\usage{
RcssProperty(selector, property, Rcssclass = NULL, Rcss = "default")
}
\arguments{
\item{selector}{character, name of selector, e.g. 'points'}

\item{property}{character, name of property, e.g. 'col'}

\item{Rcssclass}{character or vector, subclass in Rcss}

\item{Rcss}{Rcss object}
}
\value{
list with two ites. Component "defined" is a boolean that indicates
whether the property is defined in the style. Component "value" gives
the actual value associated to the property.
}
\description{
Extract information about property and its value
}
\examples{

style1 <- Rcss(text="points { cex: 2; }")
# cex is defined, col is not defined
RcssProperty("points", "cex", Rcss=style1)
RcssProperty("points", "col", Rcss=style1)

}
