% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devices-properties.R
\name{devices_properties}
\alias{devices_properties}
\alias{devices_properties_list}
\title{Properties (of devices) API methods}
\usage{
devices_properties_list(
  device_id,
  show_deleted = FALSE,
  store_token = "option",
  token = NULL,
  silent = FALSE
)
}
\arguments{
\item{device_id}{The id of the device}

\item{show_deleted}{If \code{TRUE}, shows the soft deleted properties. Default to \code{FALSE}}

\item{store_token}{Where your token is stored. If \code{option} it will be retrieved from the .Rprofile (not cross-session and default),
if \code{envir} it will be retrieved from environmental variables list (cross-session)}

\item{token}{A valid token created with \code{create_auth_token} or manually.
It not \code{NULL} it has higher priority then \code{store_token}}

\item{silent}{Whether to hide or show API method success messages (default \code{FALSE})}
}
\value{
A tibble showing the information about properties for given device.
}
\description{
List properties associated to a given device
}
\details{
Official documentation: \href{https://www.arduino.cc/reference/en/iot/api/#api-DevicesV2-devicesV2GetProperties}{devicesV2GetProperties}
}
\examples{
\dontrun{
library(dplyr)

Sys.setenv(ARDUINO_API_CLIENT_ID = 'INSERT CLIENT_ID HERE')
Sys.setenv(ARDUINO_API_CLIENT_SECRET = 'INSERT CLIENT_SECRET HERE')
create_auth_token()

device_id = "fa7ee291-8dc8-4713-92c7-9027969e4aa1"

### check properties list ###
devices_properties_list(device_id = device_id)
}
}
