% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regional.consistency.probs.R
\name{regional.consistency.probs}
\alias{regional.consistency.probs}
\title{Calculate Regional Consistency Probabilities}
\usage{
regional.consistency.probs(f.s, PI, alpha, power, seed)
}
\arguments{
\item{f.s}{A numeric vector representing the proportion of patients in region s(=1,...,S)
among patients in the entire trial population. Values must sum to 1.}

\item{PI}{A numeric value specifying the threshold for Method 1 (typically set at 0.5).}

\item{alpha}{A numeric value representing the one-sided level of significance.}

\item{power}{A numeric value representing the target power.}

\item{seed}{A random number seed.}
}
\value{
A list containing the following components:
\describe{
\item{f.s}{The input proportion of patients in each region}
\item{PI}{The input threshold value for Method 1}
\item{alpha}{The input one-sided significance level}
\item{power}{The input target power}
\item{seed}{The input seed number}
\item{Uncond.Method1}{Unconditional regional consistency probability for Method 1}
\item{Joint.Method1}{Joint regional consistency probability for Method 1}
\item{Cond.Method1}{Conditional regional consistency probability for Method 1}
\item{Uncond.Method2}{Unconditional regional consistency probability for Method 2}
\item{Joint.Method2}{Joint regional consistency probability for Method 2}
\item{Cond.Method2}{Conditional regional consistency probability for Method 2}
}
}
\description{
This function calculates approximate regional consistency probabilities
using Methods 1 and 2 proposed by Japanese MHLW (2007).
The function can obtain:
\itemize{
\item Unconditional regional consistency probabilities
\item Joint regional consistency probabilities
\item Conditional regional consistency probabilities
}
For technical details, please see Homma (2024)
}
\examples{
regional.consistency.probs(
  f.s = c(0.1, 0.45, 0.45),
  PI = 0.5,
  alpha = 0.025,
  power = 0.8,
  seed = 123
)

}
