% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dLIN.R
\name{dLIN}
\alias{dLIN}
\alias{pLIN}
\alias{qLIN}
\alias{rLIN}
\alias{hLIN}
\title{Lindley distribution}
\usage{
dLIN(x, mu, log = FALSE)

pLIN(q, mu, lower.tail = TRUE, log.p = FALSE)

qLIN(p, mu, lower.tail = TRUE, log.p = FALSE)

rLIN(n, mu)

hLIN(x, mu, log = FALSE)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x], otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dLIN} gives the density, \code{pLIN} gives the distribution 
function, \code{qLIN} gives the quantile function, \code{rLIN}
generates random deviates and \code{hLIN} gives the hazard function.
}
\description{
Density, distribution function, quantile function, 
random generation and hazard function for the Lindley distribution
with parameter \code{mu}.
}
\details{
Lindley Distribution with parameter \code{mu} has density given by

\eqn{f(x) = \frac{\mu^2}{\mu+1} (1+x) \exp(-\mu x),}

for x > 0 and \eqn{\mu > 0}. These function were taken form LindleyR package.
}
\examples{
old_par <- par(mfrow = c(1, 1)) # save previous graphical parameters

## The probability density function
curve(dLIN(x, mu=1.5), from=0.0001, to=10,
      col="red", las=1, ylab="f(x)")

## The cumulative distribution and the Reliability function
par(mfrow=c(1, 2))
curve(pLIN(x, mu=2), from=0.0001, to=10, col="red", las=1, ylab="F(x)")
curve(pLIN(x, mu=2, lower.tail=FALSE), from=0.0001, 
      to=10, col="red", las=1, ylab="R(x)")

## The quantile function
p <- seq(from=0, to=0.99999, length.out=100)
plot(x=qLIN(p, mu=2), y=p, xlab="Quantile", las=1, ylab="Probability")
curve(pLIN(x, mu=2), from=0, add=TRUE, col="red")

## The random function
hist(rLIN(n=10000, mu=2), freq=FALSE, xlab="x", las=1, main="")
curve(dLIN(x, mu=2), from=0.09, to=5, add=TRUE, col="red")

## The Hazard function
curve(hLIN(x, mu=2), from=0.001, to=10, col="red", ylab="Hazard function", las=1)

par(old_par) # restore previous graphical parameters
}
\references{
\insertRef{lindley1958fiducial}{RelDists}

\insertRef{lindley1965introduction}{RelDists}
}
\author{
Freddy Hernandez, \email{fhernanb@unal.edu.co}
}
