% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initValuesOW_TTT.R
\name{initValuesOW}
\alias{initValuesOW}
\title{Initial values and search region for Odd Weibull distribution}
\usage{
initValuesOW(
  formula,
  data = NULL,
  local_reg = loess.options(),
  interpolation = interp.options(),
  ...
)
}
\arguments{
\item{formula}{an object of class \code{\link{formula}} with the response on
the left of an operator \code{~}. The right side must be 
\code{1}.}

\item{data}{an optional data frame containing the response variables. If 
data is not specified, the variables are taken from the 
environment from which \code{initValuesOW} is called.}

\item{local_reg}{a list of control parameters for LOESS. See 
\code{\link[EstimationTools]{loess.options}}.}

\item{interpolation}{a list of control parameters for interpolation function. See 
\code{\link[EstimationTools]{interp.options}}.}

\item{...}{further arguments passed to 
\code{\link[EstimationTools]{TTTE_Analytical}}.}
}
\value{
Returns an object of class \code{c("initValOW", "HazardShape")} containing:

\itemize{
\item \code{sigma.start} value for \eqn{sigma} parameter of OW distribution.  
\item \code{nu.start} value for \eqn{nu} parameter of OW distribution.
\item \code{sigma.valid} search region for \eqn{sigma} parameter of OW distribution.  
\item \code{nu.valid} search region for \eqn{nu} parameter of OW distribution.
\item \code{TTTplot} Total Time on Test transform computed from the data.
\item \code{hazard_type} shape of the hazard function determined from the TTT
plot.
}
}
\description{
This function can be used so as to get suggestions about initial values
and the search region for parameter estimation in \code{OW} distribution.
}
\details{
This function performs a non-parametric estimation of the empirical total 
time on test (TTT) plot. Then, this estimated curve can be used so as to 
get suggestions about initial values and the search region for parameters 
based on hazard shape associated to the  shape of empirical TTT plot.
}
\examples{
# Example 1
# Bathtuh hazard and its corresponding TTT plot
y1 <- rOW(n = 1000, mu = 0.1, sigma = 7, nu = 0.08)
my_initial_guess1 <- initValuesOW(formula=y1~1)
summary(my_initial_guess1)
plot(my_initial_guess1, par_plot=list(mar=c(3.7,3.7,1,2.5),
                                     mgp=c(2.5,1,0)))

curve(hOW(x, mu = 0.022, sigma = 8, nu = 0.01), from = 0, 
      to = 80, ylim = c(0, 0.04), col = "red", 
      ylab = "Hazard function", las = 1)

# Example 2
# Bathtuh hazard and its corresponding TTT plot with right censored data
\donttest{
y2 <- rOW(n = 1000, mu = 0.1, sigma = 7, nu = 0.08)
status <- c(rep(1, 980), rep(0, 20))
my_initial_guess2 <- initValuesOW(formula=Surv(y2, status)~1)
summary(my_initial_guess2)
plot(my_initial_guess2, par_plot=list(mar=c(3.7,3.7,1,2.5),
                                     mgp=c(2.5,1,0)))

curve(hOW(x, mu = 0.022, sigma = 8, nu = 0.01), from = 0, 
      to = 80, ylim = c(0, 0.04), col = "red", 
      ylab = "Hazard function", las = 1)
}
}
\author{
Jaime Mosquera Gutiérrez \email{jmosquerag@unal.edu.co}
}
\concept{initValOW}
