% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilidades.R
\name{Bazi}
\alias{Bazi}
\title{Utilities. Generation of *.bazi files}
\usage{
Bazi(
  Ano = 0,
  Mes,
  camino = "",
  cota = 3,
  Auto = TRUE,
  votes,
  seats,
  Titulo = ""
)
}
\arguments{
\item{Ano}{. For automatic procedure only. This value indicates the year of the data
you want to download. This data can be numerical or of character type (better numeric)}

\item{Mes}{. For automatic procedure only. This value refers to the month in which the
election was held. It must be of character type with two digits always  i.e. "04" is valid but "4" is not.}

\item{camino}{. For manual and automatic procedure. You must indicate a local
hard disk path where you download the file from the Ministry of Interior (once
the process is finished it will be deleted automatically), and then the file will
be written with the extension '.bazi' ready to be used by BAZI. Please note that
this path must indicate a disk space with write permission so that the R program
can save the results into it.}

\item{cota}{. Only for automatic procedure. It will be the electoral threshold that
the user wants to use. In the case of the Congress of Deputies in Spain it is 3 per
cent (parties with less than 3 per cent of the valid votes do not take part in the
distribution), and it is the value that has been assigned by default.}

\item{Auto}{. To choose whether to use manual and automatic procedure. If it is equal to TRUE,
the automatic procedure is executed, otherwise the manual procedure is carried out.}

\item{votes}{. Only needed for manual procedure. It must be a dataframe type
object with the following column structure: The first column must contain the
name of the electoral districts to be considered. And then there will be a column
for each political party to be taken into account, in such a way that one column
will be identified by the acronym of the corresponding party, and will contain
the votes of that formation in each of the districts where it has been presented
as an electoral option. In those places where it has not been elegible, or it has
not overcome the electoral threshold that is to be taken into account, a value of
zero is added, in such a way that the Bazi() function takes this into account
so as not to count these cases in the generation of the final file (the file
with the extension ".bazi").}

\item{seats}{. Only needed for manual procedure.  It is a two-column dataframe.
The first column contains the names of the electoral districts (which must have
the same name and be in the same order as those provided in the "votes" dataframe)
and the second column indicates the number of Members of Parliament to be elected in each electoral district.}

\item{Titulo}{. Only needed for manual procedure. It must be a string of
characters that are the ones that head the file with extension ".bazi" that
is generated.}
}
\value{
The result is a flat ASCII file with its own information structure to
be read by BAZI Java program and which has the following generic name 'Congreso_AAAA_MM.bazi',
where YYYY is the year of the electoral process and MM is the two-digit month.
In the case of using a manual procedure the file will have the name 'Congreso.bazi'.
}
\description{
BAZI is a freely available Java program that implements various
methods of distributing seats for proportional representation systems. It
offers the possibility of using divisor methods as well as quota methods.
The program can be downloaded from \url{https://www.math.uni-augsburg.de/htdocs/emeriti/pukelsheim/bazi/}
Instructions on its use can be found at the following webpage:
\url{https://opus.bibliothek.uni-augsburg.de/opus4/frontdoor/index/index/docId/601}.
With this function you obtain flat ASCII files, with extension '.bazi' that
structures the data in the form that can be understood by BAZI program and
obtain the results that can be accessed with this application. This function
has been designed so that it can be used both automatically or manually, that is
to say, it will work autonomously if after giving the corresponding parameters
it connects to the databases of the Spanish Ministry of the Interior, downloads
the results and generates the file with extension ".bazi". The manual procedure,
is designed to be provided with the appropriate data and that this function is
responsible for transforming them to the format that BAZI understands to
generate the results for which it is programmed. Let's see below how to
proceed in each case.

First of all, it should be pointed out that the "camino" parameter must be
provided both with the manual and the automatic procedure, and it should indicate
the path to be used to store the file with the ".bazi" extension that is
generated as a result of this process. It must also be taken into account
that a path with writing permission for R must be provided.

The manual or automatic procedure is indicated by the "Auto" parameter of
the Bazi() function, so that if "TRUE" (default value) is valid, the automatic
procedure will be executed and otherwise the manual one.
}
\examples{
Bazi(Ano = 2019,"04","F:/")

# Manual example

vo <- data.frame(
 circu=c("c1","c2","c3","c4","c5","c6","c7","c8","c9"),
 p1=c(200,300,0,0,250,360,145,0,0),
 p2=c(0,0,450,467,576,346,234,0,437),
 p3=c(243,567,0,0,345,634,456,634,0),
 p4=c(0,367,384,134,267,0,0,364,146),
 p5=c(345,123,234,254,123,543,342,45,0),
 p6=c(23,45,234,0,0,354,254,56,123)
)

se <- data.frame(
 circu=c("c1","c2","c3","c4","c5","c6","c7","c8","c9"),
 dip=c(3,4,5,3,2,6,2,4,3)
)

Bazi(camino="F:/",Auto=FALSE, votes=vo,seats=se, Titulo="Fichero_prueba")


}
