% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regionalismo.R
\name{Regionalismo}
\alias{Regionalismo}
\title{Dimensionality of voting. Regionalism}
\usage{
Regionalismo(
  Ano = 0,
  Mes = "",
  RutaDescarga = "",
  Auto = TRUE,
  datos = "",
  PANES = "",
  Generate_PANES = FALSE
)
}
\arguments{
\item{Ano}{It is the year of the electoral process to be dealt with. It must be a four-digit numerical
value. If a manual procedure is used, no value is needed for this parameter.}

\item{Mes}{It is the month of the electoral process, it must be \strong{a string with two numerical characters},
associated with the month in which the elections took place. If a manual procedure is used, no value is
required for this parameter.}

\item{RutaDescarga}{It should be a string indicating the way to download the file from the Spanish Ministry of Home Office.
This file is automatically removed if the process finish successfully. The user has to be aware that the
path provided must correspond to a computer location where the user has read and write permissions,
otherwise the process will not be completed. If a manual procedure is used, no value is required for this parameter.}

\item{Auto}{It can take the logical values TRUE or FALSE. By default, it has the value TRUE to indicate that
the user wants the process to be automatic. In the case of wanting a manual process, this parameter will take the value FALSE.}

\item{datos}{In this parameter you must enter the values that will be processed if manual processing is
chosen, i.e. "Auto=FALSE". It must be a data.frame with the following structure: The first column must
contain the name of the intermediate unit (in the case of Spain the autonomous regions), in the second
column must include the name of the lower units (in the case of Spain the name of the provinces), and then
there must be a column for each political party containing the votes obtained by that party in each lower
unit (for Spain in each province). The value of the name for each of these columns must be the acronyms
that identify each political party.}

\item{PANES}{Here the user should provide the complete path of the csv-type file containing, for each
party, the information on whether that party is regionalist or not. "1" will denote that the party is
regionalist or nationalist and "0" that it is not. These values will appear in the second column of
that csv file. The first column must have the acronym of each political party under study.}

\item{Generate_PANES}{A boolean type parameter, by default its value is FALSE. In case it is TRUE,
the csv file indicated in the "PANES" parameter will be generated. The first line of this file will
be the following: "PARTIES,PANE", which will be the name of the variables with which the function
will work internally. In this case, the csv file generated will contain a column with the acronyms of
the political parties, and then, manually, "1" will be written down if the match is "PANE" (nationalist or regionalist party) and 0 if it
is "NO PANE" (non-nationalist or non-regionalist party). That is to say, with the parameter Generate_PANES = TRUE, a help system is obtained to
obtain the file that must be passed with the "PANES" parameter. But this csv file can also be generated
in a completely manual way, if the user wishes.}
}
\value{
It returns a list of all the indicators obtained with this function. This initial list,
in turn, contains two other lists:
\enumerate{
\item VRtaD. It is composed of three other lists, each one containing a data.frame with the following information:
\strong{$VRta_Provincias}: contains the values of the VRta indicator at the lowest level (in the case of
Spain, the provinces). \strong{$VRta_CCAA} contains the VRta indicator at the intermediate level (in the
case of Spain, at an autonomous region level). \strong{$VRtaD} contains the indicator VRtaD at the lowest level.
\item VRD. Composed of three other lists, each one containing a data.frame with the following information:
\strong{$inferior_medio} contains the VRD value of the lower level (provinces in Spain) with respect to the
intermediate level (autonomous regions in Spain).  \strong{$inferior_superior} contains the VRD value for the
lower level with respect to the upper level (State level). \strong{$medio_superior} contains the value of the
VRD index at the intermediate level with respect to the upper one.
}
}
\description{
With this function we calculate the regionalism indexes described in the book
"Analysis of electoral data" from Pablo Oñate y Francisco A. Ocaña (page 48). The reader is
referred to this publication in order to understand the meaning of the indicators computed
with this function. More precisely, the Regionalist Voting Index (VRta), the Differentiated
Regionalist Voting Index (VRtaD), and the Differentiated Regional Voting Index (VRD) will be calculated.
}
\examples{
r <- Regionalismo(Ano=2019,Mes = "11",RutaDescarga = "F:/",
 PANES = system.file("regionalismo","Regionalismo.csv", package="Relectoral"))

}
