% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{protzko2020}
\alias{protzko2020}
\title{Data from Protzko et al. (2020)}
\format{
A data frame with 80 rows and 6 variables
}
\source{
The relevant files were downloaded from \url{https://osf.io/42ef9/}
    on January 24, 2022. The R markdown script
    "Decline effects main analysis.Rmd" was executed and the relevant
    variables from the objects "ES_experiments" and "decline_effects" were
    saved.
}
\usage{
data("protzko2020")
}
\description{
Data from "High Replicability of Newly-Discovered Social-behavioral
Findings is Achievable" by Protzko et al. (2020). The variables are as follows:
\describe{
\item{\code{experiment}}{Experiment name}
\item{\code{type}}{Type of study, either "original", "self-replication", or
"external-replication"}
\item{\code{lab}}{The lab which conducted the study, either 1, 2, 3, or 4.}
\item{\code{smd}}{Standardized mean difference effect estimate}
\item{\code{se}}{Standard error of standardized mean difference effect estimate}
\item{\code{n}}{Total sample size of the study}
}
}
\details{
This data set originates from a prospective replication project
    involving four laboratories. Each of them conducted four original studies
    and for each original study a replication study was carried out within
    the same lab (self-replication) and by the other three labs
    (external-replication). Most studies used simple between-subject designs
    with two groups and a continuous outcome so that for each study, an
    estimate of the standardized mean difference (SMD) could be computed from
    the group means, group standard deviations, and group sample sizes. For
    studies with covariate adjustment and/or binary outcomes, effect size
    transformations as described in the supplementary material of Protzko
    (2020) were used to obtain effect estimates and standard errors on SMD
    scale. The data set is licensed under a CC-By Attribution 4.0
    International license, see
    \url{https://creativecommons.org/licenses/by/4.0/} for the terms of
    reuse.
}
\examples{
data("protzko2020", package = "ReplicationSuccess")

## forestplots of effect estimates
graphics.off()
parOld <- par(mar = c(5, 8, 4, 2), mfrow = c(4, 4))
experiments <- unique(protzko2020$experiment)
for (ex in experiments) {
  ## compute CIs
  dat <- subset(protzko2020, experiment == ex)
  za <- qnorm(p = 0.975)
  plotDF <- data.frame(lower = dat$smd - za*dat$se,
                       est = dat$smd,
                       upper = dat$smd + za*dat$se)
colpalette <- c("#000000", "#1B9E77", "#D95F02")
cols <- colpalette[dat$type]
yseq <- seq(1, nrow(dat))

## forestplot
plot(x = plotDF$est, y = yseq, xlim = c(-0.15, 0.8),
     ylim = c(0.8*min(yseq), 1.05*max(yseq)), type = "n",
     yaxt = "n", xlab = "Effect estimate (SMD)", ylab = "")
abline(v = 0, col = "#0000004D")
arrows(x0 = plotDF$lower, x1 = plotDF$upper, y0 = yseq, angle = 90,
       code = 3, length = 0.05, col = cols)
points(y = yseq, x = plotDF$est, pch = 20, lwd = 2, col = cols)
axis(side = 2, at = yseq, las = 1, labels = dat$type, cex.axis = 0.85)
title(main = ex)
}
par(parOld)
}
\references{
Protzko, J., Krosnick, J., Nelson, L. D., Nosek, B. A., Axt, J.,
    Berent, M., ... Schooler, J. (2020, September 10). High Replicability of
    Newly-Discovered Social-behavioral Findings is Achievable.
    \doi{10.31234/osf.io/n2a9x}

Protzko, J., Berent, M., Buttrick, N., DeBell, M., Roeder, S. S., Walleczek,
J., ... Nosek, B. A. (2021, January 5). Results & Data. Retrieved from
\url{https://osf.io/42ef9/}
}
\keyword{data}
