test_that("Output of function 'PPpSceptical' stays the same.", {
    # set all possible parameters
    grid <- expand.grid(
        level = c(1e-4, 0.5, 0.999999),
        c = c(0.001, 1, 10),
        alpha = c(1e-4, 0.5, 0.999999),
        power = c(1e-4, 0.5, 0.999999),
        alternative = c("one.sided", "two.sided"),
        stringsAsFactors = FALSE
    )
    out <- lapply(
        seq_len(nrow(grid)),
        function(i) {
            tryCatch({
                PPpSceptical(
                    level = grid[i, "level"],
                    c = grid[i, "c"],
                    alpha = grid[i, "alpha"],
                    power = grid[i, "power"],
                    alternative = grid[i, "alternative"]
                )
            },
            warning = function(w) "warning!",
            error = function(e) "error!"
            )
        }
    )
    res <- list(2.74568005302894e-06, 0.24999999994854, 7.31229965359e-09,
                1.24814171663888e-09, 0.24999999994854, 1.94748284957755e-14,
                1.00191051753781e-17, 0.24999999994854, 1.52859868774815e-27,
                1.55305338246708e-14, 4.53190044194655e-05, 1.95664783333003e-18,
                2.25602599103469e-29, 9.99999936663494e-09, 7.83583339112121e-38,
                9.72598290125284e-90, 3.11587698445835e-36, 5.56603287884155e-111,
                5.29378808030092e-05, 0.435847748771324, 3.17684637596427e-07,
                3.20268749934888e-06, 0.721696512388424, 4.97681685482235e-10,
                1.27236187604021e-08, 0.849072157895698, 1.6362601757917e-15,
                0.00194093944242325, 0.54675524610925, 6.91207072036682e-05,
                0.217533954560113, 0.999800010000168, 0.00941464553111454,
                0.475107936318611, 0.999900000000167, 0.0449006042566394,
                2.74568005302894e-06, 0.24999999994854, 7.31229965359e-09,
                1.24814171663888e-09, 0.24999999994854, 1.94748284957755e-14,
                1.00191051753781e-17, 0.24999999994854, 1.52859868774815e-27,
                0.00266460018692045, 0.559741972507836, 0.000138125861524407,
                0.736147084374432, 0.999997999991892, 0.18152823319375, 0.901953083313685,
                0.999998999990892, 0.471482131174168, 0.00395370471557233,
                0.605620359938867, 0.00026073599093569, 0.999999904098106,
                1.0000000000001, 0.999974425377228, 0.999999962318372, 1.0000000000001,
                0.999994029880361, 0.00266460018692045, 0.559741972507836,
                0.000138125861524407, 0.736147084374432, 0.999997999991892,
                0.18152823319375, 0.901953083313685, 0.999998999990892, 0.471482131174168,
                0.00435493783996628, 0.618152798692781, 0.000295492898136014,
                0.999999999865908, 1.00000000001873, 0.999999931703603, 0.999999999940832,
                1.00000000001873, 0.999999979237076, 5.18238964803194e-06,
                0.358051660675962, 0.999998438894551, 1.59107351611129e-09,
                0.296000475138716, 0.999998450369635, 2.95882548277833e-17,
                0.181930047463664, 0.999998546483859, 0.00111468159505048,
                0.594162661594353, 0.999999210405556, 0.0243221662005768,
                0.987957914169378, 0.999999985288143, 0.081033357305666,
                0.994061666012616, 0.999999992921883, 0.00173954054942938,
                0.59804480040728, 0.999999218480303, 0.149708281823165, 0.998554081863479,
                0.999999998433719, 0.377027178730829, 0.999281500498805,
                0.999999999213776, 0.00187712468512446, 0.598475221833947,
                0.999999219367273, 0.211562290234211, 0.99921159633288, 0.999999999185158,
                0.474564864200067, 0.999607871045717, 0.999999999591238,
                1.77490922031903e-05, 0.39997099977299, 0.999998587824717,
                6.46764708418126e-08, 0.394697648607202, 0.999998747590086,
                1.95424136866371e-12, 0.513597091536401, 0.999999292957224,
                4.48723994870251e-06, 0.354842718583911, 0.999998427492023,
                9.52409140805327e-10, 0.2889161646842, 0.999998427492023,
                1.30278444498274e-18, 0.147594067331835, 0.999998427492019,
                0.00310328856914529, 0.609440371057348, 0.999999242677263,
                0.9999999108852, 0.999999999976118, 1.00000000000027, 0.999999964004106,
                0.999999999976118, 1.00000000000027, 0.00253066509240495,
                0.601314682074913, 0.999999225337666, 0.901726453413239,
                0.999999015560512, 0.999999999992717, 0.971024974180955,
                0.999999502992423, 0.999999999993032, 0.00235284584529514,
                0.600059649320712, 0.999999222661316, 0.648441951721372,
                0.999975537023978, 0.999999999971358, 0.86050647463023, 0.999987708324903,
                0.999999999981109)
    expect_equal(out, res)
})
