% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResIN_boots_prepare.R
\name{ResIN_boots_prepare}
\alias{ResIN_boots_prepare}
\title{ResIN_boots_prepare}
\usage{
ResIN_boots_prepare(
  ResIN_object,
  n = 10000,
  boots_type = "resample",
  resample_size = NULL,
  weights = NULL,
  save_input = FALSE,
  seed_boots = 42
)
}
\arguments{
\item{ResIN_object}{A ResIN object to prepare bootstrapping workflow.}

\item{n}{Bootstrapping sample size. Defaults to 10.000.}

\item{boots_type}{What kind of bootstrapping should be performed? If set to "resample", function performs row-wise re-sampling of raw data (useful for e.g., sensitivity or power analysis). If set to "permute", function will randomly reshuffle raw item responses (useful e.g., for simulating null-hypothesis distributions). Defaults to "resample".}

\item{resample_size}{Optional parameter determining sample size when \code{boots_type} is set to "resample". Defaults of to number of rows in raw data.}

\item{weights}{An optional weights vector that can be used to adjust the re-sampling of observations. Should either be NULL (default) or a positive numeric vector of the same length as the original data.}

\item{save_input}{Should all input information for each bootstrap iteration (including re-sampled/permuted data) be stored. Set to FALSE by default to save a lot of memory and disk storage.}

\item{seed_boots}{Random seed for bootstrap samples}
}
\value{
A list object containing n re-sampled or permuted copies of the raw data, along with a list of instructions for how to perform the ResIN analysis and what outputs to generate.
}
\description{
Prepare a ResIN-based bootstrap analysis
}
\examples{
## Load the 12-item simulated Likert-type toy dataset
data(lik_data)

# Apply the ResIN function to toy Likert data:
ResIN_obj <- ResIN(lik_data, cor_method = "spearman", network_stats = TRUE,
                      generate_ggplot = FALSE)

\dontrun{
# Prepare for bootstrapping
prepped_boots <- ResIN_boots_prepare(ResIN_obj, n=5000, boots_type="permute")

# Execute the prepared bootstrap list
executed_boots <-  ResIN_boots_execute(prepped_boots, parallel = TRUE, detect_cores = TRUE)

# Extract results - here for example, the network (global)-clustering coefficient
ResIN_boots_extract(executed_boots, what = "global_clustering", summarize_results = TRUE)
}

}
