% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateShiftBayesFactor.R
\name{calculateShiftBayesFactor}
\alias{calculateShiftBayesFactor}
\title{Bayes Factors in support of a shift in diversification rates over a given
time interval.}
\usage{
calculateShiftBayesFactor(
  rate_trace,
  time_trace,
  rate_name,
  time_name,
  t1,
  t2,
  prior_prob = 0.5,
  decrease = TRUE,
  return_2lnBF = TRUE
)
}
\arguments{
\item{rate_trace}{(list; no default) The processed Rev output of the rate
of interest through time for computation (output of readTrace()).}

\item{time_trace}{(list; no default) The processed Rev output of the
change/interval times of the rate of interest through time for computation
(output of readTrace()).}

\item{rate_name}{(character; no default) The name of the parameter
(e.g. "speciation") for which Bayes Factor is to be calculated.}

\item{time_name}{(character; no default) The name of the interval times
(e.g. "interval_times) for the rate change times.}

\item{t1}{(numeric; no default) Support will be assessed for a shift between
time t1 and time t2 (t1 < t2).}

\item{t2}{(numeric; no default) Support will be assessed for a shift between
time t1 and time t2 (t1 < t2).}

\item{prior_prob}{(numeric; 0.5) The prior probability of a shift over this
interval (default of 0.5 applies to standard HSMRF- and GMRF-based models).}

\item{decrease}{(logical; default TRUE) Should support be assessed for a
decrease in the parameter (if TRUE) or an increase (if FALSE) between
t1 and t2?}

\item{return_2lnBF}{(logical; TRUE) Should the 2ln(BF) be returned
(if TRUE) or simply the BF (if FALSE)?}
}
\value{
The Bayes Factor.
}
\description{
This function computes the Bayes Factor in favor of a rate-shift between
time t1 and t2 (t1 < t2).
The default assumption (suitable to standard HSMRF and GMRF models) is
that the prior probability of a shift is 0.5.
}
\examples{

\donttest{
#' # download the example datasets to working directory
url_times <-
   "https://revbayes.github.io/tutorials/intro/data/primates_EBD_speciation_times.log"
dest_path_times <- "primates_EBD_speciation_times.log"
download.file(url_times, dest_path_times)

url_rates <-
   "https://revbayes.github.io/tutorials/intro/data/primates_EBD_speciation_rates.log"
dest_path_rates <- "primates_EBD_speciation_rates.log"
download.file(url_rates, dest_path_rates)

# to run on your own data, change this to the path to your data file
speciation_time_file <- dest_path_times
speciation_rate_file <- dest_path_rates

speciation_times <- readTrace(speciation_time_file, burnin = 0.25)
speciation_rate <- readTrace(speciation_rate_file, burnin = 0.25)

calculateShiftBayesFactor(speciation_rate,
                          speciation_times,
                          "speciation",
                          "interval_times",
                          0.0,40.0,
                          decrease=FALSE)

# remove file
# WARNING: only run for example dataset!
# otherwise you might delete your data!
file.remove(dest_path_times, dest_path_rates)
}

}
\references{
Kass and Raftery (1995) Bayes Factors.
\emph{JASA}, \bold{90 (430)}, 773-795.
}
