% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processPopSizes.R
\name{processPopSizes}
\alias{processPopSizes}
\title{Process Population Sizes}
\usage{
processPopSizes(
  population_size_log = "",
  interval_change_points_log = "",
  model = "constant",
  burnin = 0.25,
  probs = c(0.025, 0.975),
  summary = "median",
  num_grid_points = 100,
  spacing = "exponential",
  max_age = NULL,
  min_age = NULL,
  distribution = FALSE
)
}
\arguments{
\item{population_size_log}{(vector of character strings or
single character string; "") Path to population sizes log file(s)}

\item{interval_change_points_log}{(vector of character strings or
single character string; "") Path to interval change points log file(s).
If not given, a constant process with only one population size is assumed.}

\item{model}{(string, default: "constant") The demographic model of the intervals.
Can be "constant" or "linear".}

\item{burnin}{(single numeric value; default: 0.25) Fraction of generations to
discard (if value provided is between 0 and 1) or number of generations (if
value provided is greater than 1).}

\item{probs}{(numeric vector; c(0.025, 0.975)) a vector of length two
containing the upper and lower bounds for the confidence intervals.}

\item{summary}{(string, default: "median") the metric to summarize the
posterior distribution, typically "mean" or "median".}

\item{num_grid_points}{(numeric; default: 100) defines the number of grid points through time for which to
evaluate the demographic functions.}

\item{spacing}{(string, default: "exponential") The spacing of grid points. Can be "exponential" or "equal".
Exponentially spaced grid points are dense towards the present and have larger distances towards the past.}

\item{max_age}{(numeric; default: NULL, i.e. not provided) defines the maximal age up to which the demographic functions should be evaluated.
If not provided, it will either be automatically set to 1e5 (in case of a constant process) or
to the maximal age provided with the interval_change_points_log.}

\item{min_age}{(numeric; default: NULL, i.e. not provided) defines the minimal age up to which the demographic functions should be evaluated.
If not provided, it will either be automatically set to 1e2 (in case of a constant process) or
to the minimal age provided with the interval_change_points_log. Can not be 0 in case of exponential spacing.}

\item{distribution}{(boolean; default: FALSE) specifies whether the summary data frame will be returned 
(distribution = FALSE) or a matrix with distributions of population size for each point on the grid and 
with the times of the grid points as row names (distribution = TRUE).}
}
\value{
List object with processed rate and, if applicable, time parameters (if distribution = FALSE). 
Matrix object with distributions of population size (if distribution = TRUE). If applicable, one row for each point on the grid, 
with the times of the grid points as row names.
}
\description{
Processing the output of a coalescent demographic analysis.
}
\details{
For processing the output of a coalescent demographic analysis.
processPopSizes() assumes that the the first size parameter (i.e. population_size[1])
corresponds to the present. processPopSizes() partly
relies on readTrace and produces a list object that can be read by
plotPopSizes() to visualize the results. For now, only one log file per
parameter type is accepted (i.e. log files from multiple runs must be
combined before reading into the function).
}
