% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfuzzycoco-package.R
\docType{package}
\name{Rfuzzycoco-package}
\alias{Rfuzzycoco}
\alias{Rfuzzycoco-package}
\title{Rfuzzycoco: Provides an R Interface to the 'FuzzyCoCo' C++ Library and Extends It}
\description{
Provides and extends the 'Fuzzy Coco' algorithm by wrapping the 'FuzzyCoCo' 'C++' Library, cf \url{https://github.com/Lonza-RND-Data-Science/fuzzycoco}. 'Fuzzy Coco' constructs systems that predict the outcome of a human decision-making process while providing an understandable explanation of a possible reasoning leading to it. The constructed fuzzy systems are composed of rules and linguistic variables. This package provides a 'S3' classic interface (fit_xy()/fit()/predict()/evaluate()) and a 'tidymodels'/'parsnip' interface, a custom engine with custom iteration stop criterion and progress bar support as well as a systematic implementation that do not rely on genetic programming but rather explore all possible combinations.
}
\section{Features}{


\code{Rfuzzycoco} provides the FuzzyCoCo algorithm, cf \emph{Fuzzy CoCo: a cooperative-coevolutionary approach to fuzzy modeling} from \href{https://orcid.org/0000-0002-2113-6498}{Carlos Andrés Peña-Reyes}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/Lonza-RND-Data-Science/Rfuzzycoco}
  \item Report bugs at \url{https://github.com/Lonza-RND-Data-Science/Rfuzzycoco/issues}
}

}
\author{
\strong{Maintainer}: Karl Forner \email{karl.forner@gmail.com}

}
