% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getJobs.R
\name{getJobs}
\alias{getJobs}
\title{Bookmarked and Recommended Jobs on LinkedIn}
\usage{
getJobs(token, suggestions = NULL, bookmarks = NULL, partner = 0)
}
\arguments{
\item{token}{Authorization token.}

\item{suggestions}{TRUE or FALSE. If TRUE, it will return LinkedIn's job recommendations.}

\item{bookmarks}{TRUE or FALSE. If TRUE, it will return jobs you've bookmarked on LinkedIn.}

\item{partner}{Indicate whether you belong to the Partnership Program. Values: 0 or 1}
}
\value{
Returns a dataframe of recommended or bookmarked jobs.
}
\description{
\code{getJobs} can be used to retrieve your bookmarked and 
suggested jobs.
}
\details{
This function can return either jobs you've bookmarked on LinkedIn, 
or jobs LinkedIn is recommending for you, but not both at the same time.
}
\examples{
\dontrun{

job.suggestions <- getJobs(in.auth, suggestions=TRUE)
job.bookmarks <- getJobs(in.auth, bookmarks=TRUE)

## Will return NULL
job.fail <- getJobs(in.auth) 

}
}
\author{
Michael Piccirilli \email{michael.r.piccirilli@gmail.com}
}
\seealso{
\code{\link{searchJobs}}
}

