% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{FBm}
\alias{FBm}
\title{Simulation of fractional Brownian motion}
\usage{
FBm(H, x_start = 0, t_start = 0, t_end = 1, N = 1000, plot = FALSE)
}
\arguments{
\item{H}{Hurst parameter which lies between 0 and 1.}

\item{x_start}{Value of the process at the initial time point (additive constant mean).}

\item{t_start}{Initial time point.}

\item{t_end}{Terminal time point.}

\item{N}{Number of time steps on the interval \code{[t_start,t_end]}.
Default set to 1000.}

\item{plot}{Logical: If \code{TRUE}, the realisation of the fractional Brownian
motion is plotted in interactive sessions.}
}
\value{
A data frame where the first column is \code{t} and second
column is simulated values of the realisation of fractional Brownian motion
with added constant mean.
}
\description{
This function simulates a realisation of the fractional Brownian motion over
the time interval \code{[t_start,t_end]} for a provided Hurst parameter, which has
the initial value \code{x_start}.
}
\examples{
FBm(H = 0.5, plot = TRUE)
}
\references{
Banna, O., Mishura, Y., Ralchenko, K., & Shklyar, S. (2019). Fractional Brownian motion:
Approximations and Projections. John Wiley & Sons. \doi{doi:10.1002/9781119476771.app3}.
}
\seealso{
\code{\link{FGn}}, \code{\link{Bm}}, \code{\link{GHBMP}}, \code{\link{Bbridge}}, \code{\link{FBbridge}}
}
