% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Analyses_functions_2.R
\name{cross_T}
\alias{cross_T}
\title{Estimated crossing times}
\usage{
cross_T(X, A, subI = NULL, plot = FALSE, vline = FALSE)
}
\arguments{
\item{X}{Data frame where the first column is a numeric time sequence \eqn{t}
and the second one is the values of the time series \eqn{X(t)}.}

\item{A}{Constant level as a numeric value.}

\item{subI}{Time sub-interval as a vector, where the lower bound is
the first element and the upper bound is the second. Optional: If provided estimated crossing
times of the sub-interval is returned, otherwise the whole time interval is considered.}

\item{plot}{Logical: If \code{TRUE}, the time series, the constant level and corresponding \eqn{t} values are plotted
in interactive sessions.}

\item{vline}{Logical: If \code{TRUE}, a vertical line is plotted at the crossing point(s).}
}
\value{
The estimated crossing times at a given level.
}
\description{
Computes the estimated \eqn{t} value(s), in which a time series crosses a specific
constant level for the provided time interval or its sub-interval.
}
\examples{
t <- seq(0, 1, length = 100)
TS <- data.frame("t" = t, "X(t)" = rnorm(100))
cross_T(TS, 0.1, subI = c(0.2, 0.8), plot = TRUE, vline = TRUE)

}
\seealso{
\code{\link{cross_rate}}, \code{\link{cross_mean}}
}
