#' Leukemia Data
#'
#' Records for 33 leukemia patients.
#'
#' Description: The following features are present:
#' \code{wbc}: white blood cell count;
#' \code{ag}: presence or absence of a certain
#' morphological characteristic in the white cells; and
#' \code{y}: binary response
#' variable, equals \code{1} if the patient survives more than 52 weeks, \code{0} otherwise.
#'
#' Format: Numeric, 33 rows and 3 columns.
#'
#' @docType data
#'
#' @usage data(leuk.dat)
#'
#' @format An object of class \code{"data.frame"}.
#'
#' @source Cook, R.D. and Weisberg, S. (1982). Residuals and Influence in Regression, Chapman
#' and Hall; Johnson, W. (1985), Influence measures for logistic regression: another point of
#' view, Biometrika, 72, 59-65.
#'
#' @examples
#' data(leuk.dat)
"leuk.dat"
