% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.R
\name{robin_surv_comparison}
\alias{robin_surv_comparison}
\title{Log Hazard Ratio Estimation and Log-Rank Test via Score Function}
\usage{
robin_surv_comparison(
  score_fun,
  vars,
  data,
  exp_level,
  control_level,
  unadj_score_fun = NULL,
  ...
)
}
\arguments{
\item{score_fun}{(\code{function}) The log-rank score function to be used for both estimation and testing.}

\item{vars}{(\code{list}) A list containing \code{levels}, \code{treatment}, and \code{covariates}.}

\item{data}{(\code{data.frame}) The data frame containing the survival data.}

\item{exp_level}{(\code{count}) Level of the experimental treatment arm.}

\item{control_level}{(\code{count}) Level of the control treatment arm.}

\item{unadj_score_fun}{(\code{function} or \code{NULL}) Optional unadjusted score function, see details.}

\item{...}{Additional arguments passed to \code{score_fun}.}
}
\value{
A list containing:
\itemize{
\item \code{estimate}: The estimated log hazard ratio.
\item \code{se}: The standard error of the estimated log hazard ratio.
\item \code{hr_n}: The number of observations used in the estimation.
\item \code{hr_sigma_l2}: The variance of the log-rank statistic used in the estimation.
\item \code{test_stat}: The log-rank test statistic.
\item \code{p_value}: The two-sided p-value of the log-rank test.
\item \code{test_score}: The log-rank score statistic.
\item \code{test_n}: The number of observations used in the log-rank test.
\item \code{test_sigma_l2}: The variance of the log-rank statistic used in the log-rank test.
}
}
\description{
This function combines the estimation of the log hazard ratio and the log-rank test
using a score function. Only two treatment arms are being compared and the \code{data} is subset accordingly.
}
\details{
If an unadjusted score function is provided in \code{unadj_score_fun}, then it is used to estimate the
log hazard ratio first. This unadjusted log hazard ratio estimate is then passed on to the adjusted
score function \code{score_fun} as \code{theta_hat}. This is required when the score function is adjusted for covariates.
}
\keyword{internal}
