\name{YX_ecological_data}
\alias{YX_ecological_data}
\title{Ecological data set to test the functions of \emph{RolWinMulCor} 
}
\description{
The data set \code{\link{YX_ecological_data}} contains four columns, the first one (``Years'') is the time (years from 1700 to 1936), the second is the first component principal (``PC1'') of the reconstructed Atlantic Bluefin Tuna (BFT) captures (Ganzedo et al., 2016, Polanco-Martínez et al., 2018), the third are reconstructions of sea surface temperature (``SST'') from the Northern Hemisphere (NH) (Mann et al. 2009), and the fourth column contains reconstructions of total solar irradiance (``TSI'') (Lean 2000). 
}
\usage{data(YX_ecological_data)
}
\format{One file in ASCII format and columns are separated by spaces. 
}
\source{
Ganzedo, U., Polanco-Martínez, J. M., Caballero-Alfonso, A. M., Faria, S. H., Li, J., Castro-Hernández, J. J. (2016). Climate effects on historic bluefin tuna captures in the Gibraltar Strait and Western Mediterranean. Journal of Marine Systems, 158, 84-92. \cr 
<URL: \doi{10.1016/j.jmarsys.2016.02.002}>. \cr

Lean, J. (2000). Evolution of the Sun's spectral irradiance since the Maunder Minimum. Geophysical Research Letters, 27(16), 2425-2428. <URL: \doi{10.1029/2000GL000043}>. Lean Web TSI data set: <URL: \url{https://www.ncdc.noaa.gov/paleo-search/study/5788}>. \cr 

Mann, M.E., Zhang, Z., Rutherford, S., Bradley, R.S., Hughes, M.K., Shindell, Ammann, G., Faluvegi, G., Ni, F. (2009). Global signatures and dynamical origins of the little ice age and medieval climate anomaly. Science 326, 1256-1260. <URL: \doi{10.1126/science.1177303}>. Mann et al. Web SST data set: <URL: \url{http://www.meteo.psu.edu/holocene/public_html/supplements/MultiproxySpatial09/results/nhscr}>. \cr 

Polanco-Martínez, J. M., Caballero-Alfonso, A. M., Ganzedo, U., Castro-Hernández, J. J. (2018). A reconstructed database of historic bluefin tuna captures in the Gibraltar Strait and Western Mediterranean. Data in Brief, 16, 206-210. <URL: \doi{10.1016/j.dib.2017.11.028}>. \cr 
}
\keyword{dataset2}
