% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Geometry.R
\name{PCS2CCS}
\alias{PCS2CCS}
\title{Convert Polar Coordinate System to Cartesian Coordinate System.}
\usage{
PCS2CCS(theta = 0:360, a = 1, ab = 1, orig = c(0, 0),
  rotation = 0, clockwise = FALSE)
}
\arguments{
\item{theta}{angle in PCS.}

\item{a}{Semi-major (Ellipse) or Radium (Ring).}

\item{ab}{Semi-major over semi-minor. ab=1 for a Ring.}

\item{orig}{Reference orgin. Default = c(0, 0)}

\item{rotation}{Rotation of the theta=0}

\item{clockwise}{Whether clockwise, Default = FALSE}
}
\value{
(x,y) in Cartesian Coordinate System.
}
\description{
Convert Polar Coordinate System to Cartesian Coordinate System.
}
\examples{
x1=PCS2CCS(a=10, ab=1.5)
x2=PCS2CCS(a=9, ab=1.2)
c1 = ab2c(a=10, ab=1.5)
c2 = ab2c(a=9, ab=1.2)

plot(x1, type='n', xlim=c(-10,10), ylim=c(-10,10), asp=1)
abline(h=0, v=0, asp=1, lty=2)
lines(x1, col=2);
points(c1, 0, col=2)
lines(x2, col=3);
points(c2, 0, col=3)

# Test 2
x1=PCS2CCS(a=10, ab=1.5, clockwise = FALSE, rotation=0);
x2=PCS2CCS(a=8, ab=1.5, clockwise = FALSE, rotation=45);
plot(x1, asp=1, col=terrain.colors(nrow(x1)), pch=19)
points(x2, asp=1, col=terrain.colors(nrow(x1)))

}
