% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2d.R
\name{plotplanet}
\alias{plotplanet}
\title{Plot a planet}
\usage{
plotplanet(orig = c(0, 0), rad = 1, theta = 0,
  fun = graphics::lines, cols = "gray", ab = 1, arrow = TRUE,
  arrow.len = 0.1, ...)
}
\arguments{
\item{orig}{Origin}

\item{rad}{Radius of the planet}

\item{theta}{Angle of the Arrow inside of the planet}

\item{fun}{Function to plot the planet}

\item{cols}{Color of planet and arrow.}

\item{ab}{Semi-major over semi-minor. ab=1 for the planet}

\item{arrow}{Whether plot the arrow.}

\item{arrow.len}{Length in arrow function.}

\item{...}{More options in plot function.}
}
\description{
Plot a planet
}
\examples{

a = 10;
ab=1.5
x1=PCS2CCS(a=a, ab=ab)
c1 = ab2c(a=a, ab=ab)
plot(x1, type='l', xlim=c(-10,10), ylim=c(-10,10), asp=1, col='gray')
Arrow.pcs(theta = 1:12 * 30, r1=0, r2=a, ab1=ab, length=.1, col=2, o1 = c(c1,0), o2=c(0,0))
pos = PCS2CCS(theta = 1:12 * 30, a=a, ab=ab)
plotplanet(orig = pos, arrow.len=0.1)

}
