% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percentile_table.R
\name{percentile_table}
\alias{percentile_table}
\title{percentile_table}
\usage{
percentile_table(vals = NULL, na_rm = TRUE, title = NULL, table_width = NULL)
}
\arguments{
\item{vals}{A required vector of numeric values}

\item{na_rm}{A logical which if TRUE removes NA values before
the calculations}

\item{title}{A string that sets the table's title. The string can contain R markdown/html style syntax.}

\item{table_width}{A numeric that sets the overall table width in pixels.}
}
\value{
A named list with a gt object and a data.table with percentile values contained in the display table.
}
\description{
Function locates values corresponding to percentiles in a vector of numeric data.
  Function displays a table with lower/upper locations, values,
  average and spread between lower/upper from median to one hundred and twenty-eighth percentiles.
  The function returns a list with a viewable gt table along with the data.table
  containing the table's values.

  The "label" column of the table correspond to the following percentiles:

\enumerate{
 \item "M" = Half (i.e. the median)
 \item "F" = Fourth (i.e. quartiles 25/75)
 \item "E" = Eighth
 \item "D" = Sixteenth
 \item "C" = Thirty-secondth
 \item "B" = Sixty-fourth
 \item "A" = One hundred and twenty-eighth
}
}
\examples{
library(gt)
library(data.table)
library(RplotterPkg)

set.seed(12345)
random_vals <- stats::rnorm(n = 1000, mean = 20, sd = 4)
percentile_random_lst <- RplotterPkg::percentile_table(
  vals = random_vals
)
percentile_random_lst$table_gt

}
