\name{Gfirstguess}
\alias{Gfirstguess}
\title{First guess from a pick file	
}
\description{
Extract the lat lon from the pick file.
}
\usage{
Gfirstguess(Ldat, type = "first")
}
\arguments{
  \item{Ldat}{Matrix of data information
}
  \item{type}{one of "first", "mean", or "median"
}
}
\details{
Either the earliest arrival or the average station is
returned.  Used internally in the earthquake location program
to provide a first guess.
}
\value{
vector, lat, lon, z and tee
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{Klocate
}
\examples{

data(GH, package='RSEIS')
WW = RSEIS::uwpfile2ypx(GH$pickfile)

twpx  = latlonz2wpx(WW, GH$pickfile$STAS )

g1 = Gfirstguess(twpx, type = "first")

}
\keyword{misc}
