% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_frequencies.R,
%   R/pv_rrepest_frequencies.R
\name{grouped_sum_freqs}
\alias{grouped_sum_freqs}
\title{Grouped frequency counts}
\usage{
grouped_sum_freqs(data, small.level, big.level, w = NULL)

grouped_sum_freqs(data, small.level, big.level, w = NULL)
}
\arguments{
\item{data}{(data frame) Data to analyze.}

\item{small.level}{(string vector) all variables to get grouped sum.}

\item{big.level}{(string vector) Must be fully contained in variables from small.level}

\item{w}{(string) Numeric variable from which to get weights (if NULL then 1).}
}
\value{
Data frame containing the frequency counts

Data frame with frequencies from the grouped sum of small.level and big.level used for getting percentages.
}
\description{
Computes a data frame with frequency counts.
}
\examples{
grouped_sum_freqs(data = mtcars,small.level = c("cyl","am"),big.level = c("cyl"))

grouped_sum_freqs(data = mtcars,small.level = c("cyl","gear"),big.level = c("cyl"))
}
