% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsearch_obj.R
\name{rsearch_obj}
\alias{rsearch_obj}
\title{Create Rsearch object}
\usage{
rsearch_obj(
  readcount_data,
  sequence_data,
  sample_data,
  sample_id_col = "sample_id"
)
}
\arguments{
\item{readcount_data}{(Required). A file path or a data frame (or tibble)
containing OTU count data, typically the output from
\code{\link{vs_cluster_size}} or similar. This must have one row per OTU and
one column per sample. The first column must contain OTU identifiers
corresponding to those in the first column of \code{sequence_data}, and the
remaining columns must have names matching the sample identifiers in
\code{sample_data}. OTUs and samples not found across all data structures are
discarded.}

\item{sequence_data}{(Required). A file path or a data frame (or tibble)
containing centroid sequences representing each OTU, typically obtained from
clustering (\code{\link{vs_cluster_size}}) or denoising
(\code{\link{vs_cluster_unoise}}). The first column must be called
\code{Header} and contain OTU identifiers. One of the remaining columns must
be named \code{Sequence}, containing the actual DNA sequences. Additional
columns may include taxonomic classification data, e.g. from
\code{\link{vs_sintax}}.}

\item{sample_data}{(Required). A file path or a data frame (or tibble)
containing metadata about each sample. Samples are assumed to be in rows, and
one of the columns \strong{must} contain a unique identifier for each sample
that matches the column names in \code{readcount_data}.}

\item{sample_id_col}{(Optional). A character string specifying the name of
the column in \code{sample_data} that contains the unique sample identifiers.
This column will be used to match sample metadata to read count data.
Defaults to \code{"sample_id"}.}
}
\value{
A straightforward named list with three elements:
\itemize{
  \item \code{readcount.mat}: A numeric matrix of OTU abundances with OTUs as
  rows and samples as columns.
  \item \code{sequence.df}: A data.frame with one row for each OTU sequence
  and
  \item \code{sampledata.df}: A data frame containing data about the samples.
}
}
\description{
\code{rsearch_obj} standardizes and organizes data into an
Rsearch object. An Rsearch object is a list containing three elements with
data structures that can be used as input to build a \code{phyloseq} object
in the \code{phyloseq} package.
}
\details{
This function standardizes and organizes data into an
Rsearch object: a structured three key data components used or generated
during the Rsearch workflow: read count data, sequence data, and sample data.

The function accepts three datasets—read count data, sequence data,
and sample metadata, and returns a streamlined input
suitable for constructing a phyloseq object using the
\code{\link{rsearch2phyloseq}} function. The implementation uses a
standard \code{list} in R rather than a specialized class providing an open
and easily accessible structure.

To convert this object into a \code{\link[phyloseq]{phyloseq}} object, use
\code{\link{rsearch2phyloseq}}.
}
\examples{
# Define inputs
readcount.dta <- system.file("extdata/readcount_data.tsv", package = "Rsearch")
sequence.dta <- system.file("extdata/sequence_data.tsv", package = "Rsearch")
sample.dta <- system.file("extdata/sample_data.tsv", package = "Rsearch")

# Create Rsearch object
obj <- rsearch_obj(readcount_data = readcount.dta,
                   sequence_data = sequence.dta,
                   sample_data = sample.dta,
                   sample_id_col = "sample_id")

# Convert Rsearch object to phyloseq object
phy_obj <- rsearch2phyloseq(obj, sample_id_col = "sample_id")

# Convert phyloseq object to Rsearch object
rsearch_obj <- phyloseq2rsearch(phy_obj)

}
\seealso{
\link{rsearch2phyloseq} \link{phyloseq2rsearch}
}
