% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPC.R
\name{Rule3}
\alias{Rule3}
\title{Rule 3}
\usage{
Rule3(x, nPoints = 6, convention = 1, equalBreaksSeries = 1, ...)
}
\arguments{
\item{x}{Numerical vector}

\item{nPoints}{Sequence of consequtive points to be evaluated}

\item{convention}{Calculation according to 'minitab' or 'jmp' (see details)}

\item{equalBreaksSeries}{Equal values break consequtive series of points}

\item{...}{unspecified arguments of a function}
}
\value{
Vector of the same length as x
}
\description{
Six points in a row steadily increasing or decreasing.
}
\details{
0 means: ok \cr
1 means: violation \cr

parameter equalBreakSeries is internally encoded as: 1 for TRUE and 2 for FALSE \cr

parameter convention is internally encoded as: 1 for 'minitab' and 2 for 'jmp'

Difference in convention parameter is as follows: \cr
'minitab' - seven points in a row steadily increasing or decreasing \cr
'jmp' - six points in a row steadily increasing or decreasing
}
\examples{
Rule3(x = rnorm(20), nPoints = 6, convention = 1, equalBreaksSeries = 1)
}
