% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_incong.R
\name{max_incong}
\alias{max_incong}
\title{Algortihm for maximizing incongruence between two phylogenies}
\usage{
max_incong(
  HS,
  treeH,
  treeS,
  n,
  N,
  method = "paco",
  symmetric = FALSE,
  ei.correct = "none",
  percentile = 0.99,
  diff.fq = FALSE,
  strat = "sequential",
  cl = 1
)
}
\arguments{
\item{HS}{Host-Symbiont association matrix.}

\item{treeH}{Host phyolgeny. An object of class "phylo".}

\item{treeS}{Symbiont phylogeny. An object of class "phylo".}

\item{n}{Number of associations.}

\item{N}{Number of runs.}

\item{method}{Specifies the desired global-fit method (PACo or ParaFit).
The default is \code{PACo}. Options are \code{"paco"} (PACo) or
\code{"paraF"} (ParaFit).}

\item{symmetric}{Specifies the type of Procrustes superimposition. Default
is \code{FALSE}, indicates that the superposition is applied
asymmetrically (S depends on H). If \code{TRUE}, PACo is applied
symmetrically (dependency between S and H is reciprocal).}

\item{ei.correct}{Specifies how to correct potential negative eigenvalues
from the conversion of phylogenetic distances into Principal
Coordinates: \code{"none"} (the default) indicates that no correction
is applied, particularly if H and S are ultrametric; \code{"sqrt.D"}
takes the element-wise square-root of the phylogenetic distances;
\code{"lingoes"} and \code{"cailliez"} apply the classical Lingoes
and Cailliez corrections, respectively.}

\item{percentile}{Percentile to evaluate (\emph{p}). Default is
\code{0.99} (99\\\%).}

\item{diff.fq}{Determines whether a correction to detect those associations
that present a similar contribution to (in)congruence and occur with
some frequency at the 0.01 and 0.99 percentiles. These correction
avoid multiple associations being overrepresented.
If \code{TRUE} a corrected frequency value (observed in p -
observed in (p-1)) is computed for each host-symbiont association.}

\item{strat}{Flag indicating whether execution is to be  \code{"sequential"}
or \code{"parallel"}. Default is \code{"sequential"},
resolves \R expressions sequentially in the current \R
process. If \code{"parallel"} resolves \R expressions in parallel in
separate \R sessions running in the background.}

\item{cl}{Number of cluster to be used for parallel computing.
\code{\link[parallelly:availableCores]{parallelly::availableCores()}}
returns the number of clusters available.
Default is \code{cl = 1} resulting in \code{"sequential"} execution.y.}
}
\value{
A dataframe with host-symbiont associations in rows. The first and
second columns display the names of the host and symbiont terminals,
respectively. The third column designates the host-symbiont
association by pasting the names of the terminals, and the fourth
column displays the frequency of occurrence of each host-symbiont
association in \emph{p}. If \code{diff.fq = TRUE}, column 5 displays
the corrected frequencies.
}
\description{
Prunes the host (H) and symbiont (S) phylogenies to conform with the trimmed
matrix and computes the given global-fit method (PACo or ParaFit) between
the pruned trees. Then, determines the frequency of each host-symbiont
association occurring in a given percentile of cases that maximize
phylogenetic incongruence.
}
\section{NOTE}{

The \code{node.label} object in both trees can not contain NAs or null
values (i.e. no numeric value). All nodes should have a value. Else
remove node labels within the \code{"phylo"} class tree
with \code{tree$node.label <- NULL}. For more details, see
\code{\link[distory:dist.multiPhylo]{distory::dist.multiPhylo()}}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{  \code{GD} method can not be used with the trimmed matrices produced
  with \code{\link[=trimHS_maxI]{trimHS_maxI()}} or with the algorithm
  \code{\link[=max_incong]{max_incong()}} for those datasets with
  multiple associations.
}\if{html}{\out{</div>}}
}

\examples{
data(nuc_pc)
N = 1 #for the example, we recommend 1e+4 value
n = 15
NPi <- max_incong(np_matrix, NUCtr, CPtr, n, N, method = "paco",
                  symmetric = FALSE, ei.correct = "sqrt.D",
                  percentile = 0.99, diff.fq = TRUE)


}
