% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tropsvm.R
\name{tropsvm}
\alias{tropsvm}
\title{Tropical Support Vector Machines}
\usage{
tropsvm(x, y, auto.assignment = FALSE, assignment = NULL, ind = 1)
}
\arguments{
\item{x}{a data matrix, of dimension nobs x nvars; each row is an observation vector.}

\item{y}{a response vector with one label for each row/component of x.}

\item{auto.assignment}{a logical value indicating if to provide an \code{assignment} manually.
If \code{FALSE}, an input is required, otherwise the function automatically
finds a good assignment.(default: FALSE)}

\item{assignment}{a numeric vector of length 4 indicating the sectors of tropical hyperplane that the
data will be assigned to. The first and third elements in the \code{assignment} are the coordinates of
an observed point in data matrix \code{x} believed from the first category where the maximum and second maximum
of the vector addition between the fitted optimal tropical hyperplane and the point itself are achieved.
The meanings for the second and the fourth element in the \code{assignment} are the same
but for the points in the second category. Namely, the first and second values in the \code{assignment}
are the indices of sectors where the two point clouds are assigned. Not needed when \code{auto.assignment = TRUE}. (default: NULL)}

\item{ind}{a numeric value or a numeric vector ranging from 1 to 70 indicating which classification method
to be used. There are 70 different classification methods. Details of a given method can be retrieved by \code{summary}.
 The different classification methods are proposed to resolve the issue when points fall on the intersections of sectors.
 Users can have personal choices if better knowledge is assumed. (default: 1)}
}
\value{
An object with S3 class \code{tropsvm} containing the fitted model, including:
\item{apex}{The negative apex of the fitted optimal tropical hyperplane.}
\item{assignment}{The user-input or auto-found \code{assignment}.}
\item{index}{The user-input classification method.}
\item{levels}{The name of each category, consistent with categories in \code{y}.}
}
\description{
Fit a discriminative two-class classifier via linear programming defined by the tropical
hyperplane which maximizes the minimum tropical distance from data points
to itself in order to separate the data points into sectors (half-spaces)
in the tropical projective torus.
}
\examples{

# data generation
library(Rfast)
e <- 100
n <- 10
N <- 100
s <- 10
x <- rbind(
  rmvnorm(n, mu = c(5, -5, rep(0, e - 2)), sigma = diag(s, e)),
  rmvnorm(n, mu = c(-5, 5, rep(0, e - 2)), sigma = diag(s, e))
)
y <- as.factor(c(rep(1, n), rep(2, n)))
newx <- rbind(
  rmvnorm(N, mu = c(5, -5, rep(0, e - 2)), sigma = diag(s, e)),
  rmvnorm(N, mu = c(-5, 5, rep(0, e - 2)), sigma = diag(s, e))
)
newy <- as.factor(rep(c(1, 2), each = N))

# train the tropical svm
tropsvm_fit <- tropsvm(x, y, auto.assignment = TRUE, ind = 1)

coef(tropsvm_fit)

# test with new data
pred <- predict(tropsvm_fit, newx)

# check with accuracy
table(pred, newy)

# compute testing accuracy
sum(pred == newy) / length(newy)
}
\seealso{
\code{predict}, \code{coef} and the \code{cv.tropsvm} function.
}
