% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{tsEvaPlotReturnLevelsGPDFromAnalysisObj}
\alias{tsEvaPlotReturnLevelsGPDFromAnalysisObj}
\title{tsEvaPlotReturnLevelsGPDFromAnalysisObj}
\usage{
tsEvaPlotReturnLevelsGPDFromAnalysisObj(
  nonStationaryEvaParams,
  stationaryTransformData,
  timeIndex,
  trans,
  ...
)
}
\arguments{
\item{nonStationaryEvaParams}{The non-stationary parameters obtained from the analysis object.}

\item{stationaryTransformData}{The stationary transformed data obtained from the analysis object.}

\item{timeIndex}{The index at which the time-varying analysis should be estimated.}

\item{trans}{The transformation used to fit the EVD. Can be "ori" for no transformation or "rev" for reverse transformation.}

\item{...}{Additional arguments to be passed to the function.}
}
\value{
\describe{
\item{Plot 1}{RLtstep: return level curve with confidence interval for the
selected timeIndex}
\item{Plot 2}{}beam: beam of return level curve for all with highlited curve
for selected timeIndex}
}
\description{
\code{tsEvaPlotReturnLevelsGPDFromAnalysisObj} is a function that plots the return levels for a Generalized Pareto Distribution (GPD) using the parameters obtained from an analysis object. It considers non-stationarity by considering time-varying parameters and their associated standard errors.
}
\examples{
 # Example usage of TsEvaNs function
timeAndSeries <- ArdecheStMartin
#go from six-hourly values to daily max
timeAndSeries <- max_daily_value(timeAndSeries)
#keep only the 30 last years
yrs <- as.integer(format(timeAndSeries$date, "\%Y"))
tokeep <- which(yrs>=1990)
timeAndSeries <- timeAndSeries[tokeep,]
timeWindow <- 10*365 # 10 years
TSEVA_data <- TsEvaNs(timeAndSeries, timeWindow,
transfType = 'trendPeaks',tail = 'high')
nonStationaryEvaParams <- TSEVA_data[[1]]
stationaryTransformData <- TSEVA_data[[2]]
timeIndex=2
trans='ori'
result = tsEvaPlotReturnLevelsGPDFromAnalysisObj(nonStationaryEvaParams, stationaryTransformData,
timeIndex, trans)
result
}
\references{
Mentaschi, L., Vousdoukas, M., Voukouvalas, E., Sartini, L., Feyen, L., Besio, G., and Alfieri, L. (2016). The transformed-stationary approach: a generic and simplified methodology for non-stationary extreme value analysis. \emph{Hydrology and Earth System Sciences}, 20, 3527-3547. doi:10.5194/hess-20-3527-2016.
}
\seealso{
\code{\link[=tsEvaPlotReturnLevelsGPD]{tsEvaPlotReturnLevelsGPD()}} and \code{\link[=tsEvaPlotAllRLevelsGPD]{tsEvaPlotAllRLevelsGPD()}}
}
