% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnp_rangebagging.R
\name{pnp_rangebagging}
\alias{pnp_rangebagging}
\title{Internal function for rangebagging in plug-and-play SDMs.}
\usage{
pnp_rangebagging(data, method, object = NULL, v = 100, d = 2, p = 0.5)
}
\arguments{
\item{data}{dataframe of covariates}

\item{method}{one of either "fit" or "predict"}

\item{object}{fitted object returned by a pnp_... function. Only needed when method = "predict"}

\item{v}{Integer. Number of votes to use in the aggregation, default is 100.}

\item{d}{Integer. Number of dimensions (i.e. covariates) to use in aggregations, default is 2.}

\item{p}{Numeric.  Fraction of observations (i.e. occurrences) to use in each replicate aggregation. Default is 0.5}
}
\description{
This function both fits rangebagging models \insertCite{Drake2015-sb}{S4DM} and projects those distributions to new covariates.
}
\details{
For fitting, an object is not required (and will be ignored). For prediction, parameters v,p,and d are not needed and will be ignored.
}
\references{
\insertAllCited{}
}
\keyword{internal}
