% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{S7_data}
\alias{S7_data}
\alias{S7_data<-}
\title{Get/set underlying "base" data}
\usage{
S7_data(object)

S7_data(object, check = TRUE) <- value
}
\arguments{
\item{object}{An object from a S7 class}

\item{check}{If \code{TRUE}, check that \code{value} is of the correct type and run
\code{\link[=validate]{validate()}} on the object before returning.}

\item{value}{Object used to replace the underlying data.}
}
\value{
\code{S7_data()} returns the data stored in the base object;
\verb{S7_data<-()} is called for its side-effects and returns \code{object}
invisibly.
}
\description{
When an S7 class inherits from an existing base type, it can be useful
to work with the underlying object, i.e. the S7 object stripped of class
and properties.
}
\examples{
Text <- new_class("Text", parent = class_character)
y <- Text(c(foo = "bar"))
y
S7_data(y)

S7_data(y) <- c("a", "b")
y
}
