% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{integral_peak}
\alias{integral_peak}
\title{Computes integral of a very peaked function}
\usage{
integral_peak(logfun, xx = seq(-100, 10, 2), xcutoff = 2,
  ycutoff = 40, ymaxthreshold = 1e-12)
}
\arguments{
\item{logfun}{the logarithm of the function to integrate}

\item{xx}{the initial set of points on which to evaluate the function}

\item{xcutoff}{when the maximum has been found among the xx, this parameter sets the width of the interval to find the maximum in}

\item{ycutoff}{set the threshold below which (on a log scale) the function is deemed negligible, i.e. that it does not contribute to the integral)}

\item{ymaxthreshold}{sets the deviation allowed in finding the maximum among the xx}
}
\value{
the result of the integration
}
\description{
# computes the logarithm of the integral of exp(logfun) from 0 to Inf under the following assumptions:
}
\references{
Haegeman, B. & R.S. Etienne (2017). A general sampling formula for community structure data. Methods in Ecology & Evolution. In press.
}
