% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe.R
\name{safe}
\alias{safe}
\title{Solve the sign-aligned frequency-severity (SAFE) model}
\usage{
safe(
  x,
  y,
  k,
  lambda,
  alpha = 1,
  eps = 1e-08,
  maxit = 1e+05,
  eps2 = 1e-08,
  ind_p,
  int_gam = NULL,
  int_beta = NULL
)
}
\arguments{
\item{x}{A numeric matrix of dimensions \eqn{n \times p}, where \eqn{n} is the number of observations
and \eqn{p} is the number of predictors.}

\item{y}{A numeric vector of length \eqn{n}, representing the loss values (severity). These are assumed
to follow a Gamma distribution with shape parameter \code{alpha} and scale parameter
\eqn{\theta = \exp(x^\top \gamma) / \alpha}.}

\item{k}{A numeric vector of length \eqn{n}, representing the number of claims (frequency), assumed to follow
a Poisson distribution with mean \eqn{\mu = x^\top \beta}.}

\item{lambda}{A user-supplied numeric vector of tuning parameters. The function will compute the solution
for each value in \code{lambda}.}

\item{alpha}{The shape parameter for the Gamma distribution (default is 1).}

\item{eps}{Convergence tolerance for updating \code{beta} (default is \code{1e-8}).}

\item{maxit}{An integer specifying the maximum number of iterations (default is \code{1e5}).}

\item{eps2}{Convergence tolerance for updating \code{gamma} (default is \code{1e-8}).}

\item{ind_p}{A user-provided vector specifying which predictors should share the same sign
across frequency and severity.}

\item{int_gam}{Optional numeric vector or matrix providing initial values for \code{gamma}; defaults to \code{NULL}.}

\item{int_beta}{Optional numeric vector or matrix providing initial values for \code{beta}; defaults to \code{NULL}.}
}
\value{
An object of class \code{safe}, which is a list containing:
\item{\code{beta}}{A \eqn{p \times L} matrix of frequency-model coefficients, where \eqn{p} is the number of predictors
      and \eqn{L} is the number of \code{lambda} values.}
\item{\code{gamma}}{A \eqn{p \times L} matrix of severity-model coefficients, with the same dimensions
      as \code{beta}.}
\item{\code{lambda}}{The (sorted) sequence of \code{lambda} values used in the estimation.}
\item{\code{npass_beta}}{Total number of iterations used to update \code{beta} across all \code{lambda} values.}
\item{\code{npass_gamma}}{Total number of iterations used to update \code{gamma} across all \code{lambda} values.}
\item{\code{jerr}}{An integer flag for warnings or errors; \code{0} indicates no issues encountered.}
}
\description{
This function fits a Poisson-Gamma regression framework that aligns the signs of certain predictors in both
the Poisson frequency component and the Gamma severity component. The solution path is computed at a
sequence of tuning parameter values (\code{lambda}).
}
\details{
The function uses an **accelerated proximal gradient descent** algorithm to simultaneously estimate
\code{beta} (for the Poisson frequency model) and \code{gamma} (for the Gamma severity model) under
a sign-alignment constraint for selected predictors (controlled by \code{ind_p}).
}
\examples{
set.seed(1)
n <- 100
p <- 5
x <- matrix(rnorm(n * p), nrow = n, ncol = p)
beta_true <- rep(0.1, 5)
gamma_true <- c(rep(1, 3), -1, -1)
mu <- x \%*\% beta_true
k <- rpois(n, lambda = exp(mu))
alpha_val <- 1
theta <- exp(x \%*\% gamma_true) / alpha_val
y <- rgamma(n, shape = alpha_val, scale = theta)
lambda_val <- 1
fit <- safe(x, y, k, 1, ind_p = c(1, 1, 1, 0, 0))

}
\keyword{model}
\keyword{regression}
