% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrospective_AM.R
\name{retrospective_AM}
\alias{retrospective_AM}
\title{retrospective_AM (retrospective of Assessment model in MSE)}
\usage{
retrospective_AM(MSE, MP, sim = 1, plot_legend = FALSE)
}
\arguments{
\item{MSE}{An object of class \link[MSEtool:MSE-class]{MSEtool::MSE}.}

\item{MP}{Character. The name of the management procedure created by \code{\link[=make_MP]{make_MP()}} containing the assessment model.}

\item{sim}{Integer between 1 and MSE@nsim. The simulation number for which the retrospectives will be plotted.}

\item{plot_legend}{Logical. Whether to plot legend to reference year of assessment in the MSE.}
}
\value{
A series of figures for SSB, depletion, fishing mortality, and vulnerable biomass (VB) estimated in the MP
over the course of the closed-loop simulation against the values generated in the operating model (both historical
and projected).
}
\description{
Plots the true retrospective of an assessment model during the closed-loop simulation. A series of time series estimates of SSB, F, and VB
are plotted over the course of the MSE are plotted against the operating model (true) values (in black).
}
\details{
For assessment models that utilize annual exploitation rates (u), the instantaneous fishing mortality rates
are obtained as F = -log(1 - u).
}
\note{
This function only plots retrospectives from a single simulation in the MSE. Results from one figure
may not be indicative of general assessment behavior and performance overall.
}
\examples{
\donttest{
SP_40_10 <- make_MP(SP, HCR_MSY, diagnostic = "full")
OM <- MSEtool::testOM; OM@proyears <- 20
myMSE <- MSEtool::runMSE(OM = OM, MPs = "SP_40_10")
retrospective_AM(myMSE, MP = "SP_40_10", sim = 1)

# How to get all the estimates
library(dplyr)
assess_estimates <- lapply(1:myMSE@nMPs, function(m) {
  lapply(1:myMSE@nsim, function(x) {
    report <- myMSE@PPD[[m]]@Misc[[x]]$Assessment_report
    if (is.null(report)) {
      return(data.frame())
    } else {
      mutate(report, MP = myMSE@MPs[m], Simulation = x)
    }
  }) \%>\% bind_rows()
}) \%>\% bind_rows()
}
}
\seealso{
\link{diagnostic}
}
\author{
Q. Huynh
}
