% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoSamplesMeans.R
\name{TwoSamplesMeans}
\alias{TwoSamplesMeans}
\title{Hypothesis tests for two means}
\usage{
TwoSamplesMeans(
  x,
  y,
  var.equal = FALSE,
  H1 = "two.sided",
  xvar = NULL,
  yvar = NULL,
  paired = FALSE
)
}
\arguments{
\item{x}{a numeric vector for the data of the first group.}

\item{y}{a numeric vector for the data of the second group.}

\item{var.equal}{a logical variable indicating whether to treat
the two variances as being equal}

\item{H1}{a character string specifying the alternative
hypothesis, must be one of "two.sided" (default),}

\item{xvar}{a numeric value for the variance of the first group}

\item{yvar}{a numeric value for the variance of the second group}

\item{paired}{a logical indicating value whether you want}
}
\value{
a list with 3 elements:
\item{statistic}{the value of the test statistic}
\item{df}{If it is available, the degree of freedom for the test statistic}
\item{p.value}{the p-value for the test}
\item{test}{a character string indicating which method was used}
}
\description{
Tests for means of two independent or paired groups.
}
\details{
\code{TwoSamplesMeans} function performs hypothesis
tests on means of independent or paired two
groups. Moreover, this function can decide whether it
will use a parametric or non-parametric test.
}
\examples{

x<-c(10, 25, 35, 40, 70, 60, 50, 70, 65, 25)
y<-c(30, 20, 60, 70, 50, 90, 80, 65, 75, 60)
TwoSamplesMeans(x = x,y = y,H1 = "two.sided")
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
