% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_service.R
\docType{class}
\name{az_rec_service}
\alias{az_rec_service}
\title{Azure product recommendations service class}
\format{
An R6 object of class \code{az_rec_service}, inheriting from \code{AzureRMR::az_template}.
}
\description{
Class representing an Azure product recommendations service.
}
\section{Methods}{

\itemize{
\item \code{new(token, subscription, resource_group, name, ...)}: Initialize a recommendations service object. See 'Initialization' for more details.
\item \code{start()}: Start the service.
\item \code{stop()}: Stop the service.
\item \code{get_rec_endpoint()}: Return an object representing the client endpoint for the service.
\item \code{set_data_container(data_container="inputdata")}: sets the name of the blob container to use for storing datasets.
\item \code{delete(confirm=TRUE)}: Delete the service, after checking for confirmation.
}
}

\section{Initialization}{

Generally, the easiest way to initialize a new recommendations service object is via the \code{create_rec_service} or \code{get_rec_service} methods of the \link[AzureRMR:az_subscription]{AzureRMR::az_subscription} or \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} classes.

To create a new recommendations service, supply the following additional arguments to \code{new()}:
\itemize{
\item \code{hosting_plan}: The name of the hosting plan (essentially the size of the virtual machine on which to run the service). See below for the plans that are available.
\item \code{storage_type}: The type of storage account to use. Can be \code{"Standard_LRS"} or \code{"Standard_GRS"}.
\item \code{insights_location}: The location for the application insights service. Defaults to \code{"East US"}.
\item \code{data_container}: The default blob storage container to use for saving input datasets. Defaults to \code{"inputdata"}.
\item \code{wait}: Whether to wait until the service has finished provisioning. Defaults to TRUE.
}
}

\examples{
\dontrun{

# recommended way of retrieving a resource: via a resource group object
svc <- resgroup$get_rec_service("myrec")

# start the service backend
svc$start()

# get the service endpoint
rec_endp <- svc$get_rec_endpoint()

}
}
\seealso{
\link{rec_endpoint}, for the client interface to the recommendations service

\href{https://azure.microsoft.com/en-us/pricing/details/app-service/windows/}{List of Azure hosting plans}

\href{https://github.com/Microsoft/Product-Recommendations/blob/master/deploy/README.md}{Deployment instructions} at the Product Recommendations API repo on GitHub
}
