% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelMatch.R
\name{modelMatch}
\alias{modelMatch}
\title{Find machine learning models for use in caret}
\usage{
modelMatch(model, type = "match", similarity = 0.7)
}
\arguments{
\item{model}{The abbreviation or short name of the model you'd like to match, taken from \href{https://topepo.github.io/caret/available-models.html}{here}.}

\item{type}{The type of model. You can match the input \code{model} type with "match", or select from dual-purpose models ("dual"), regression models only ("regression"), or classification models only ("classification").}

\item{similarity}{The similarity threshold to use as a numeric value from 0 to 1. Models with a similarity score greater than this will be returned.}
}
\value{
A data.frame of models meeting the requested similarity threshold along with the model abbreviations that can be passed to \code{\link[caret:train]{caret::train()}} or to function \code{\link[=spatPredict]{spatPredict()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

As of 2023-06-15, there are 238 different machine learning models which can be used with the CARET package. As evaluating model performance is time consuming, selecting a subset of models to test prior to deciding on which model to use is essential. This function aims to facilitate this process by matching models according to their Jaccard similarity, in a process inspired by \href{https://topepo.github.io/caret/models-clustered-by-tag-similarity.html}{this section} in the CARET e-book. Model data is fetched from \href{https://topepo.github.io/caret/tag_data.csv}{here}. The result of this function can then be passed to \code{\link[=spatPredict]{spatPredict()}} to further refine model selection.
}
\details{
This function requires internet access to get an up-to-date list of models.
}
\examples{

# Find models similar to 'ranger'
modelMatch("ranger")

# Find only models with a similarity > 0.8 to 'ranger'
modelMatch("ranger", similarity = 0.8)

}
\author{
Ghislain de Laplante (gdela069@uottawa.ca or ghislain.delaplante@yukon.ca)
}
