% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Elbow_finder.R
\name{Elbow_finder}
\alias{Elbow_finder}
\title{Automatically selects the optimal number of clusters based on elbow criterion.}
\usage{
Elbow_finder(x, y, Plot = TRUE)
}
\arguments{
\item{x}{Numeric (m x 1) \code{vector} of integer values (usually, the number of clusters from 1 to G)}

\item{y}{Numeric (m x 1) \code{vector} of values (usually, the criterion values) associated with the number of groups.}

\item{Plot}{\code{Logical} value (\code{TRUE} or \code{FALSE}). If \code{Plot = TRUE} a plot of the relationship between x and y is produced.
The plot is a scatterplot with connecting lines. A vertical line is depicted in correspondence of the optimal value of x.}
}
\value{
Returns the following outputs:
\itemize{
\item{x_max_dist: optimal value of x (i.e., the x satisfying the elbow rule)}
\item{y_max_dist: optimal value of y (i.e., the y satisfying the elbow rule) }
\item{Scatterplot (non-compulsory) of x and y with connecting lines and vertical line in correspondence of the optimal value of x.}
}
}
\description{
Automatically selects the optimal number of clusters (X-axis) based on elbow criterion computed on a metric (Y-axis).
Potential metrics are the AIC and the BIC. The function can be applied to any other context in which the objective is to find the optimal X producing an elbow in Y.
}
\examples{
## Compute the Elbow criterion on two generic vectors x and y
x <- 1:10
y <- c(10,9,6,5,4,3,2,1,1,1)
Elbow_finder(x,y,Plot = TRUE)


}
